/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.distribution;

import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.nd4j.shade.jackson.annotation.JsonCreator;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class TruncatedNormalDistribution
extends Distribution {
    private double mean;
    private double std;

    @JsonCreator
    public TruncatedNormalDistribution(@JsonProperty(value="mean") double mean, @JsonProperty(value="std") double std) {
        this.mean = mean;
        this.std = std;
    }

    public double getMean() {
        return this.mean;
    }

    public void setMean(double mean) {
        this.mean = mean;
    }

    public double getStd() {
        return this.std;
    }

    public void setStd(double std) {
        this.std = std;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.mean);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.std);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TruncatedNormalDistribution other = (TruncatedNormalDistribution)obj;
        if (Double.doubleToLongBits(this.mean) != Double.doubleToLongBits(other.mean)) {
            return false;
        }
        return Double.doubleToLongBits(this.std) == Double.doubleToLongBits(other.std);
    }

    public String toString() {
        return "TruncatedNormalDistribution{mean=" + this.mean + ", std=" + this.std + '}';
    }
}

