/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.params;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.BatchNormalization;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;

public class BatchNormalizationParamInitializer
implements ParamInitializer {
    private static final BatchNormalizationParamInitializer INSTANCE = new BatchNormalizationParamInitializer();
    public static final String GAMMA = "gamma";
    public static final String BETA = "beta";
    public static final String GLOBAL_MEAN = "mean";
    public static final String GLOBAL_VAR = "var";

    public static BatchNormalizationParamInitializer getInstance() {
        return INSTANCE;
    }

    public static List<String> keys() {
        return Arrays.asList(GAMMA, BETA, GLOBAL_MEAN, GLOBAL_VAR);
    }

    @Override
    public int numParams(NeuralNetConfiguration conf) {
        return this.numParams(conf.getLayer());
    }

    @Override
    public int numParams(Layer l) {
        BatchNormalization layer = (BatchNormalization)l;
        if (layer.isLockGammaBeta()) {
            return 2 * layer.getNOut();
        }
        return 4 * layer.getNOut();
    }

    @Override
    public List<String> paramKeys(Layer layer) {
        return Arrays.asList(GAMMA, BETA, GLOBAL_MEAN, GLOBAL_VAR);
    }

    @Override
    public List<String> weightKeys(Layer layer) {
        return Collections.emptyList();
    }

    @Override
    public List<String> biasKeys(Layer layer) {
        return Collections.emptyList();
    }

    @Override
    public boolean isWeightParam(Layer layer, String key) {
        return false;
    }

    @Override
    public boolean isBiasParam(Layer layer, String key) {
        return false;
    }

    @Override
    public Map<String, INDArray> init(NeuralNetConfiguration conf, INDArray paramView, boolean initializeParams) {
        Map<String, INDArray> params = Collections.synchronizedMap(new LinkedHashMap());
        BatchNormalization layer = (BatchNormalization)conf.getLayer();
        int nOut = layer.getNOut();
        int meanOffset = 0;
        if (!layer.isLockGammaBeta()) {
            INDArray gammaView = paramView.get(new INDArrayIndex[]{NDArrayIndex.point((int)0), NDArrayIndex.interval((int)0, (int)nOut)});
            INDArray betaView = paramView.get(new INDArrayIndex[]{NDArrayIndex.point((int)0), NDArrayIndex.interval((int)nOut, (int)(2 * nOut))});
            params.put(GAMMA, this.createGamma(conf, gammaView, initializeParams));
            conf.addVariable(GAMMA);
            params.put(BETA, this.createBeta(conf, betaView, initializeParams));
            conf.addVariable(BETA);
            meanOffset = 2 * nOut;
        }
        INDArray globalMeanView = paramView.get(new INDArrayIndex[]{NDArrayIndex.point((int)0), NDArrayIndex.interval((int)meanOffset, (int)(meanOffset + nOut))});
        INDArray globalVarView = paramView.get(new INDArrayIndex[]{NDArrayIndex.point((int)0), NDArrayIndex.interval((int)(meanOffset + nOut), (int)(meanOffset + 2 * nOut))});
        if (initializeParams) {
            globalMeanView.assign((Number)0);
            globalVarView.assign((Number)1);
        }
        params.put(GLOBAL_MEAN, globalMeanView);
        conf.addVariable(GLOBAL_MEAN);
        params.put(GLOBAL_VAR, globalVarView);
        conf.addVariable(GLOBAL_VAR);
        return params;
    }

    @Override
    public Map<String, INDArray> getGradientsFromFlattened(NeuralNetConfiguration conf, INDArray gradientView) {
        BatchNormalization layer = (BatchNormalization)conf.getLayer();
        int nOut = layer.getNOut();
        LinkedHashMap<String, INDArray> out = new LinkedHashMap<String, INDArray>();
        int meanOffset = 0;
        if (!layer.isLockGammaBeta()) {
            INDArray gammaView = gradientView.get(new INDArrayIndex[]{NDArrayIndex.point((int)0), NDArrayIndex.interval((int)0, (int)nOut)});
            INDArray betaView = gradientView.get(new INDArrayIndex[]{NDArrayIndex.point((int)0), NDArrayIndex.interval((int)nOut, (int)(2 * nOut))});
            out.put(GAMMA, gammaView);
            out.put(BETA, betaView);
            meanOffset = 2 * nOut;
        }
        out.put(GLOBAL_MEAN, gradientView.get(new INDArrayIndex[]{NDArrayIndex.point((int)0), NDArrayIndex.interval((int)meanOffset, (int)(meanOffset + nOut))}));
        out.put(GLOBAL_VAR, gradientView.get(new INDArrayIndex[]{NDArrayIndex.point((int)0), NDArrayIndex.interval((int)(meanOffset + nOut), (int)(meanOffset + 2 * nOut))}));
        return out;
    }

    private INDArray createBeta(NeuralNetConfiguration conf, INDArray betaView, boolean initializeParams) {
        BatchNormalization layer = (BatchNormalization)conf.getLayer();
        if (initializeParams) {
            betaView.assign((Number)layer.getBeta());
        }
        return betaView;
    }

    private INDArray createGamma(NeuralNetConfiguration conf, INDArray gammaView, boolean initializeParams) {
        BatchNormalization layer = (BatchNormalization)conf.getLayer();
        if (initializeParams) {
            gammaView.assign((Number)layer.getGamma());
        }
        return gammaView;
    }
}

