/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.graph.vertex.impl.rnn;

import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.graph.vertex.BaseGraphVertex;
import org.deeplearning4j.nn.graph.vertex.VertexIndices;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.primitives.Pair;

public class DuplicateToTimeSeriesVertex
extends BaseGraphVertex {
    private String inputName;
    private int inputVertexIndex;

    public DuplicateToTimeSeriesVertex(ComputationGraph graph, String name, int vertexIndex, String inputVertexName) {
        this(graph, name, vertexIndex, null, null, inputVertexName);
    }

    public DuplicateToTimeSeriesVertex(ComputationGraph graph, String name, int vertexIndex, VertexIndices[] inputVertices, VertexIndices[] outputVertices, String inputName) {
        super(graph, name, vertexIndex, inputVertices, outputVertices);
        this.inputName = inputName;
        this.inputVertexIndex = graph.getConfiguration().getNetworkInputs().indexOf(inputName);
        if (this.inputVertexIndex == -1) {
            throw new IllegalArgumentException("Invalid input name: \"" + inputName + "\" not found in list of network inputs (" + graph.getConfiguration().getNetworkInputs() + ")");
        }
    }

    @Override
    public boolean hasLayer() {
        return false;
    }

    @Override
    public boolean isOutputVertex() {
        return false;
    }

    @Override
    public Layer getLayer() {
        return null;
    }

    @Override
    public INDArray doForward(boolean training) {
        int tsLength = this.graph.getInput(this.inputVertexIndex).size(2);
        int[] outShape = new int[]{this.inputs[0].size(0), this.inputs[0].size(1), tsLength};
        INDArray out = Nd4j.create((int[])outShape);
        for (int i = 0; i < tsLength; ++i) {
            out.put(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.point((int)i)}, this.inputs[0]);
        }
        return out;
    }

    @Override
    public Pair<Gradient, INDArray[]> doBackward(boolean tbptt) {
        return new Pair(null, (Object)new INDArray[]{this.epsilon.sum(new int[]{2})});
    }

    @Override
    public void setBackpropGradientsViewArray(INDArray backpropGradientsViewArray) {
        if (backpropGradientsViewArray != null) {
            throw new RuntimeException("Vertex does not have gradients; gradients view array cannot be set here");
        }
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArrays(INDArray[] maskArrays, MaskState currentMaskState, int minibatchSize) {
        INDArray[] allMasks = this.graph.getInputMaskArrays();
        if (allMasks == null || allMasks[this.inputVertexIndex] == null) {
            return null;
        }
        return new Pair((Object)allMasks[this.inputVertexIndex], (Object)MaskState.Active);
    }

    @Override
    public String toString() {
        return "DuplicateToTimeSeriesVertex(inputName=" + this.inputName + ")";
    }
}

