/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.graph.vertex.impl;

import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.graph.vertex.BaseGraphVertex;
import org.deeplearning4j.nn.graph.vertex.VertexIndices;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.primitives.Pair;

public class ReshapeVertex
extends BaseGraphVertex {
    private char order;
    private int[] newShape;
    private int[] maskShape;

    public ReshapeVertex(ComputationGraph graph, String name, int vertexIndex, char order, int[] newShape, int[] maskShape) {
        this(graph, name, vertexIndex, null, null, order, newShape, maskShape);
    }

    public ReshapeVertex(ComputationGraph graph, String name, int vertexIndex, VertexIndices[] inputVertices, VertexIndices[] outputVertices, char order, int[] newShape, int[] maskShape) {
        super(graph, name, vertexIndex, inputVertices, outputVertices);
        this.order = order;
        this.newShape = newShape;
        this.maskShape = maskShape;
    }

    @Override
    public boolean hasLayer() {
        return false;
    }

    @Override
    public Layer getLayer() {
        return null;
    }

    @Override
    public INDArray doForward(boolean training) {
        if (!this.canDoForward()) {
            throw new IllegalStateException("Cannot do forward pass: inputs not set");
        }
        if (this.inputs.length > 1) {
            throw new IllegalStateException("Reshape vertex requires a single input.");
        }
        return this.inputs[0].reshape(this.order, this.newShape);
    }

    @Override
    public Pair<Gradient, INDArray[]> doBackward(boolean tbptt) {
        if (!this.canDoBackward()) {
            throw new IllegalStateException("Cannot do backward pass: errors not set");
        }
        INDArray[] out = new INDArray[]{this.epsilon.reshape(this.order, this.inputs[0].shape())};
        return new Pair(null, (Object)out);
    }

    @Override
    public void setBackpropGradientsViewArray(INDArray backpropGradientsViewArray) {
        if (backpropGradientsViewArray != null) {
            throw new RuntimeException("Vertex does not have gradients; gradients view array cannot be set here");
        }
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArrays(INDArray[] maskArrays, MaskState currentMaskState, int minibatchSize) {
        if (maskArrays == null || maskArrays.length < 1 || maskArrays[0] == null) {
            return new Pair(null, (Object)currentMaskState);
        }
        if (this.maskShape != null) {
            return new Pair((Object)maskArrays[0].reshape(this.order, this.maskShape), (Object)currentMaskState);
        }
        if (maskArrays[0].isColumnVector()) {
            if (this.newShape.length == 2 || this.newShape.length == 4) {
                return new Pair((Object)maskArrays[0], (Object)currentMaskState);
            }
            if (this.newShape.length == 3) {
                int[] newMaskShape = new int[]{this.newShape[0], this.newShape[2]};
                return new Pair((Object)maskArrays[0].reshape(this.order, newMaskShape), (Object)currentMaskState);
            }
        } else {
            if (this.newShape.length == 3) {
                return new Pair((Object)maskArrays[0], (Object)currentMaskState);
            }
            int[] newMaskShape = new int[]{this.newShape[0] * this.newShape[2], 1};
            return new Pair((Object)maskArrays[0].reshape(this.order, newMaskShape), (Object)currentMaskState);
        }
        return new Pair((Object)maskArrays[0], (Object)currentMaskState);
    }

    @Override
    public String toString() {
        return "ReshapeVertex(id=" + this.getVertexIndex() + ",name=\"" + this.getVertexName() + "\",shape=" + this.newShape.toString() + ")";
    }
}

