/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.layers.convolution.SpaceToDepth;
import org.deeplearning4j.nn.params.EmptyParamInitializer;
import org.deeplearning4j.optimize.api.IterationListener;
import org.nd4j.linalg.api.ndarray.INDArray;

public class SpaceToDepthLayer
extends Layer {
    protected int blockSize;
    protected DataFormat dataFormat;

    protected SpaceToDepthLayer(Builder builder) {
        super(builder);
        this.blockSize = builder.blockSize;
        this.dataFormat = builder.dataFormat;
    }

    @Override
    public SpaceToDepthLayer clone() {
        return (SpaceToDepthLayer)super.clone();
    }

    @Override
    public org.deeplearning4j.nn.api.Layer instantiate(NeuralNetConfiguration conf, Collection<IterationListener> iterationListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams) {
        SpaceToDepth ret = new SpaceToDepth(conf);
        ret.setListeners(iterationListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        InputType.InputTypeConvolutional c = (InputType.InputTypeConvolutional)inputType;
        InputType.InputTypeConvolutional outputType = (InputType.InputTypeConvolutional)this.getOutputType(-1, inputType);
        return new LayerMemoryReport.Builder(this.layerName, SpaceToDepthLayer.class, inputType, outputType).standardMemory(0L, 0L).cacheMemory(MemoryReport.CACHE_MODE_ALL_ZEROS, MemoryReport.CACHE_MODE_ALL_ZEROS).build();
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.CNN) {
            throw new IllegalStateException("Invalid input for space to depth layer (layer name=\"" + this.getLayerName() + "\"): Expected CNN input, got " + inputType);
        }
        InputType.InputTypeConvolutional i = (InputType.InputTypeConvolutional)inputType;
        return InputType.convolutional(i.getHeight() / this.blockSize, i.getWidth() / this.blockSize, i.getDepth() * this.blockSize * this.blockSize);
    }

    @Override
    public ParamInitializer initializer() {
        return EmptyParamInitializer.getInstance();
    }

    @Override
    public void setNIn(InputType inputType, boolean override) {
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        if (inputType == null) {
            throw new IllegalStateException("Invalid input for space to depth layer (layer name=\"" + this.getLayerName() + "\"): input is null");
        }
        return InputTypeUtil.getPreProcessorForInputTypeCnnLayers(inputType, this.getLayerName());
    }

    @Override
    public double getL1ByParam(String paramName) {
        return 0.0;
    }

    @Override
    public double getL2ByParam(String paramName) {
        return 0.0;
    }

    @Override
    public boolean isPretrainParam(String paramName) {
        throw new UnsupportedOperationException("SpaceToDepthLayer does not contain parameters");
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    public void setDataFormat(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    public SpaceToDepthLayer() {
    }

    @Override
    public String toString() {
        return "SpaceToDepthLayer(super=" + super.toString() + ", blockSize=" + this.getBlockSize() + ", dataFormat=" + (Object)((Object)this.getDataFormat()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpaceToDepthLayer)) {
            return false;
        }
        SpaceToDepthLayer other = (SpaceToDepthLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getBlockSize() != other.getBlockSize()) {
            return false;
        }
        DataFormat this$dataFormat = this.getDataFormat();
        DataFormat other$dataFormat = other.getDataFormat();
        return !(this$dataFormat == null ? other$dataFormat != null : !((Object)((Object)this$dataFormat)).equals((Object)other$dataFormat));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SpaceToDepthLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getBlockSize();
        DataFormat $dataFormat = this.getDataFormat();
        result = result * 59 + ($dataFormat == null ? 43 : ((Object)((Object)$dataFormat)).hashCode());
        return result;
    }

    public static class Builder<T extends Builder<T>>
    extends Layer.Builder<T> {
        protected int blockSize;
        protected DataFormat dataFormat = DataFormat.NCHW;

        public Builder(int blockSize) {
            this.blockSize = blockSize;
        }

        public Builder(int blockSize, DataFormat dataFormat) {
            this.blockSize = blockSize;
            this.dataFormat = dataFormat;
        }

        public T blocks(int blockSize) {
            this.blockSize = blockSize;
            return (T)this;
        }

        public T dataFormat(DataFormat dataFormat) {
            this.dataFormat = dataFormat;
            return (T)this;
        }

        @Override
        public T name(String layerName) {
            this.layerName = layerName;
            return (T)this;
        }

        @Override
        public SpaceToDepthLayer build() {
            return new SpaceToDepthLayer(this);
        }

        public Builder() {
        }
    }

    public static enum DataFormat {
        NCHW,
        NHWC;

    }
}

