/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.api.layers.LayerConstraint;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.LayerValidation;
import org.deeplearning4j.nn.layers.convolution.SeparableConvolution2DLayer;
import org.deeplearning4j.nn.params.SeparableConvolutionParamInitializer;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.util.ConvolutionUtils;
import org.nd4j.linalg.api.ndarray.INDArray;

public class SeparableConvolution2D
extends ConvolutionLayer {
    int depthMultiplier;

    protected SeparableConvolution2D(Builder builder) {
        super(builder);
        this.hasBias = builder.hasBias;
        this.depthMultiplier = builder.depthMultiplier;
        this.convolutionMode = builder.convolutionMode;
        this.dilation = builder.dilation;
        if (builder.kernelSize.length != 2) {
            throw new IllegalArgumentException("Kernel size of should be rows x columns (a 2d array)");
        }
        this.kernelSize = builder.kernelSize;
        if (builder.stride.length != 2) {
            throw new IllegalArgumentException("Stride should include stride for rows and columns (a 2d array)");
        }
        this.stride = builder.stride;
        if (builder.padding.length != 2) {
            throw new IllegalArgumentException("Padding should include padding for rows and columns (a 2d array)");
        }
        this.padding = builder.padding;
        this.cudnnAlgoMode = builder.cudnnAlgoMode;
        this.cudnnFwdAlgo = builder.cudnnFwdAlgo;
        this.cudnnBwdFilterAlgo = builder.cudnnBwdFilterAlgo;
        this.cudnnBwdDataAlgo = builder.cudnnBwdDataAlgo;
        this.initializeConstraints(builder);
    }

    @Override
    protected void initializeConstraints(Layer.Builder<?> builder) {
        super.initializeConstraints(builder);
        if (((Builder)builder).pointWiseConstraints != null) {
            if (this.constraints == null) {
                this.constraints = new ArrayList();
            }
            for (LayerConstraint constraint : ((Builder)builder).pointWiseConstraints) {
                LayerConstraint clonedConstraint = constraint.clone();
                clonedConstraint.setParams(Collections.singleton("pW"));
                this.constraints.add(clonedConstraint);
            }
        }
    }

    @Override
    public boolean hasBias() {
        return this.hasBias;
    }

    @Override
    public SeparableConvolution2D clone() {
        SeparableConvolution2D clone = (SeparableConvolution2D)super.clone();
        if (clone.kernelSize != null) {
            clone.kernelSize = (int[])clone.kernelSize.clone();
        }
        if (clone.stride != null) {
            clone.stride = (int[])clone.stride.clone();
        }
        if (clone.padding != null) {
            clone.padding = (int[])clone.padding.clone();
        }
        return clone;
    }

    @Override
    public double getL1ByParam(String paramName) {
        switch (paramName) {
            case "W": {
                return this.l1;
            }
            case "pW": {
                return this.l1;
            }
            case "b": {
                return this.l1Bias;
            }
        }
        throw new IllegalArgumentException("Unknown parameter name: \"" + paramName + "\"");
    }

    @Override
    public double getL2ByParam(String paramName) {
        switch (paramName) {
            case "W": {
                return this.l2;
            }
            case "pW": {
                return this.l2;
            }
            case "b": {
                return this.l2Bias;
            }
        }
        throw new IllegalArgumentException("Unknown parameter name: \"" + paramName + "\"");
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<IterationListener> iterationListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams) {
        LayerValidation.assertNInNOutSet("SeparableConvolution2D", this.getLayerName(), layerIndex, this.getNIn(), this.getNOut());
        SeparableConvolution2DLayer ret = new SeparableConvolution2DLayer(conf);
        ret.setListeners(iterationListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public ParamInitializer initializer() {
        return SeparableConvolutionParamInitializer.getInstance();
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.CNN) {
            throw new IllegalStateException("Invalid input for Convolution layer (layer name=\"" + this.getLayerName() + "\"): Expected CNN input, got " + inputType);
        }
        return InputTypeUtil.getOutputTypeCnnLayers(inputType, this.kernelSize, this.stride, this.padding, this.dilation, this.convolutionMode, this.nOut, layerIndex, this.getLayerName(), SeparableConvolution2DLayer.class);
    }

    public int getDepthMultiplier() {
        return this.depthMultiplier;
    }

    public void setDepthMultiplier(int depthMultiplier) {
        this.depthMultiplier = depthMultiplier;
    }

    public SeparableConvolution2D() {
    }

    @Override
    public String toString() {
        return "SeparableConvolution2D(super=" + super.toString() + ", depthMultiplier=" + this.getDepthMultiplier() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SeparableConvolution2D)) {
            return false;
        }
        SeparableConvolution2D other = (SeparableConvolution2D)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.getDepthMultiplier() == other.getDepthMultiplier();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SeparableConvolution2D;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getDepthMultiplier();
        return result;
    }

    public static class Builder
    extends ConvolutionLayer.BaseConvBuilder<Builder> {
        public int depthMultiplier = 1;
        protected List<LayerConstraint> pointWiseConstraints;

        public Builder(int[] kernelSize, int[] stride, int[] padding) {
            super(kernelSize, stride, padding);
        }

        public Builder(int[] kernelSize, int[] stride) {
            super(kernelSize, stride);
        }

        public Builder(int ... kernelSize) {
            super(kernelSize);
        }

        public Builder() {
        }

        public Builder depthMultiplier(int depthMultiplier) {
            this.depthMultiplier = depthMultiplier;
            return this;
        }

        public Builder constrainPointWise(LayerConstraint ... constraints) {
            this.pointWiseConstraints = Arrays.asList(constraints);
            return this;
        }

        public Builder kernelSize(int ... kernelSize) {
            this.kernelSize = kernelSize;
            return this;
        }

        public Builder stride(int ... stride) {
            this.stride = stride;
            return this;
        }

        public Builder padding(int ... padding) {
            this.padding = padding;
            return this;
        }

        @Override
        public SeparableConvolution2D build() {
            ConvolutionUtils.validateConvolutionModePadding(this.convolutionMode, this.padding);
            ConvolutionUtils.validateCnnKernelStridePadding(this.kernelSize, this.stride, this.padding);
            return new SeparableConvolution2D(this);
        }
    }
}

