/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.api.layers.LayerConstraint;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.dropout.Dropout;
import org.deeplearning4j.nn.conf.dropout.IDropout;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ActivationLayer;
import org.deeplearning4j.nn.conf.layers.AutoEncoder;
import org.deeplearning4j.nn.conf.layers.BatchNormalization;
import org.deeplearning4j.nn.conf.layers.CenterLossOutputLayer;
import org.deeplearning4j.nn.conf.layers.CnnLossLayer;
import org.deeplearning4j.nn.conf.layers.Convolution1DLayer;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.DenseLayer;
import org.deeplearning4j.nn.conf.layers.DropoutLayer;
import org.deeplearning4j.nn.conf.layers.EmbeddingLayer;
import org.deeplearning4j.nn.conf.layers.GlobalPoolingLayer;
import org.deeplearning4j.nn.conf.layers.GravesBidirectionalLSTM;
import org.deeplearning4j.nn.conf.layers.GravesLSTM;
import org.deeplearning4j.nn.conf.layers.LSTM;
import org.deeplearning4j.nn.conf.layers.LocalResponseNormalization;
import org.deeplearning4j.nn.conf.layers.LossLayer;
import org.deeplearning4j.nn.conf.layers.OutputLayer;
import org.deeplearning4j.nn.conf.layers.RnnLossLayer;
import org.deeplearning4j.nn.conf.layers.RnnOutputLayer;
import org.deeplearning4j.nn.conf.layers.Subsampling1DLayer;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.conf.layers.Upsampling2D;
import org.deeplearning4j.nn.conf.layers.ZeroPadding1DLayer;
import org.deeplearning4j.nn.conf.layers.ZeroPaddingLayer;
import org.deeplearning4j.nn.conf.layers.convolutional.Cropping2D;
import org.deeplearning4j.nn.conf.layers.misc.ElementWiseMultiplicationLayer;
import org.deeplearning4j.nn.conf.layers.misc.FrozenLayer;
import org.deeplearning4j.nn.conf.layers.objdetect.Yolo2OutputLayer;
import org.deeplearning4j.nn.conf.layers.recurrent.Bidirectional;
import org.deeplearning4j.nn.conf.layers.recurrent.SimpleRnn;
import org.deeplearning4j.nn.conf.layers.util.MaskLayer;
import org.deeplearning4j.nn.conf.layers.util.MaskZeroLayer;
import org.deeplearning4j.nn.conf.layers.variational.VariationalAutoencoder;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.optimize.api.IterationListener;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.shade.jackson.annotation.JsonSubTypes;
import org.nd4j.shade.jackson.annotation.JsonTypeInfo;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.WRAPPER_OBJECT)
@JsonSubTypes(value={@JsonSubTypes.Type(value=AutoEncoder.class, name="autoEncoder"), @JsonSubTypes.Type(value=ConvolutionLayer.class, name="convolution"), @JsonSubTypes.Type(value=Convolution1DLayer.class, name="convolution1d"), @JsonSubTypes.Type(value=GravesLSTM.class, name="gravesLSTM"), @JsonSubTypes.Type(value=LSTM.class, name="LSTM"), @JsonSubTypes.Type(value=GravesBidirectionalLSTM.class, name="gravesBidirectionalLSTM"), @JsonSubTypes.Type(value=OutputLayer.class, name="output"), @JsonSubTypes.Type(value=CenterLossOutputLayer.class, name="CenterLossOutputLayer"), @JsonSubTypes.Type(value=RnnOutputLayer.class, name="rnnoutput"), @JsonSubTypes.Type(value=LossLayer.class, name="loss"), @JsonSubTypes.Type(value=DenseLayer.class, name="dense"), @JsonSubTypes.Type(value=SubsamplingLayer.class, name="subsampling"), @JsonSubTypes.Type(value=Subsampling1DLayer.class, name="subsampling1d"), @JsonSubTypes.Type(value=BatchNormalization.class, name="batchNormalization"), @JsonSubTypes.Type(value=LocalResponseNormalization.class, name="localResponseNormalization"), @JsonSubTypes.Type(value=EmbeddingLayer.class, name="embedding"), @JsonSubTypes.Type(value=ActivationLayer.class, name="activation"), @JsonSubTypes.Type(value=VariationalAutoencoder.class, name="VariationalAutoencoder"), @JsonSubTypes.Type(value=DropoutLayer.class, name="dropout"), @JsonSubTypes.Type(value=GlobalPoolingLayer.class, name="GlobalPooling"), @JsonSubTypes.Type(value=ZeroPaddingLayer.class, name="zeroPadding"), @JsonSubTypes.Type(value=ZeroPadding1DLayer.class, name="zeroPadding1d"), @JsonSubTypes.Type(value=FrozenLayer.class, name="FrozenLayer"), @JsonSubTypes.Type(value=Upsampling2D.class, name="Upsampling2D"), @JsonSubTypes.Type(value=Yolo2OutputLayer.class, name="Yolo2OutputLayer"), @JsonSubTypes.Type(value=RnnLossLayer.class, name="RnnLossLayer"), @JsonSubTypes.Type(value=CnnLossLayer.class, name="CnnLossLayer"), @JsonSubTypes.Type(value=Bidirectional.class, name="Bidirectional"), @JsonSubTypes.Type(value=SimpleRnn.class, name="SimpleRnn"), @JsonSubTypes.Type(value=ElementWiseMultiplicationLayer.class, name="ElementWiseMult"), @JsonSubTypes.Type(value=MaskLayer.class, name="MaskLayer"), @JsonSubTypes.Type(value=MaskZeroLayer.class, name="MaskZeroLayer"), @JsonSubTypes.Type(value=Cropping2D.class, name="Cropping2D")})
public abstract class Layer
implements Serializable,
Cloneable {
    protected String layerName;
    protected IDropout iDropout;
    protected List<LayerConstraint> constraints;

    public Layer(Builder builder) {
        this.layerName = builder.layerName;
        this.iDropout = builder.iDropout;
    }

    protected void initializeConstraints(Builder<?> builder) {
        LayerConstraint c2;
        ArrayList<LayerConstraint> allConstraints = new ArrayList<LayerConstraint>();
        if (builder.allParamConstraints != null && !this.initializer().paramKeys(this).isEmpty()) {
            for (LayerConstraint c : builder.allParamConstraints) {
                c2 = c.clone();
                c2.setParams(new HashSet<String>(this.initializer().paramKeys(this)));
                allConstraints.add(c2);
            }
        }
        if (builder.weightConstraints != null && !this.initializer().weightKeys(this).isEmpty()) {
            for (LayerConstraint c : builder.weightConstraints) {
                c2 = c.clone();
                c2.setParams(new HashSet<String>(this.initializer().weightKeys(this)));
                allConstraints.add(c2);
            }
        }
        if (builder.biasConstraints != null && !this.initializer().biasKeys(this).isEmpty()) {
            for (LayerConstraint c : builder.biasConstraints) {
                c2 = c.clone();
                c2.setParams(new HashSet<String>(this.initializer().biasKeys(this)));
                allConstraints.add(c2);
            }
        }
        this.constraints = !allConstraints.isEmpty() ? allConstraints : null;
        this.iDropout = builder.iDropout;
    }

    public void resetLayerDefaultConfig() {
        this.iDropout = null;
        this.constraints = null;
    }

    public Layer clone() {
        try {
            return (Layer)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract org.deeplearning4j.nn.api.Layer instantiate(NeuralNetConfiguration var1, Collection<IterationListener> var2, int var3, INDArray var4, boolean var5);

    public abstract ParamInitializer initializer();

    public abstract InputType getOutputType(int var1, InputType var2);

    public abstract void setNIn(InputType var1, boolean var2);

    public abstract InputPreProcessor getPreProcessorForInputType(InputType var1);

    public abstract double getL1ByParam(String var1);

    public abstract double getL2ByParam(String var1);

    public abstract boolean isPretrainParam(String var1);

    public IUpdater getUpdaterByParam(String paramName) {
        throw new UnsupportedOperationException("Not supported: all layers with parameters should override this method");
    }

    public abstract LayerMemoryReport getMemoryReport(InputType var1);

    public String getLayerName() {
        return this.layerName;
    }

    public IDropout getIDropout() {
        return this.iDropout;
    }

    public List<LayerConstraint> getConstraints() {
        return this.constraints;
    }

    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    public void setIDropout(IDropout iDropout) {
        this.iDropout = iDropout;
    }

    public void setConstraints(List<LayerConstraint> constraints) {
        this.constraints = constraints;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Layer)) {
            return false;
        }
        Layer other = (Layer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$layerName = this.getLayerName();
        String other$layerName = other.getLayerName();
        if (this$layerName == null ? other$layerName != null : !this$layerName.equals(other$layerName)) {
            return false;
        }
        IDropout this$iDropout = this.getIDropout();
        IDropout other$iDropout = other.getIDropout();
        if (this$iDropout == null ? other$iDropout != null : !this$iDropout.equals(other$iDropout)) {
            return false;
        }
        List<LayerConstraint> this$constraints = this.getConstraints();
        List<LayerConstraint> other$constraints = other.getConstraints();
        return !(this$constraints == null ? other$constraints != null : !((Object)this$constraints).equals(other$constraints));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Layer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $layerName = this.getLayerName();
        result = result * 59 + ($layerName == null ? 43 : $layerName.hashCode());
        IDropout $iDropout = this.getIDropout();
        result = result * 59 + ($iDropout == null ? 43 : $iDropout.hashCode());
        List<LayerConstraint> $constraints = this.getConstraints();
        result = result * 59 + ($constraints == null ? 43 : ((Object)$constraints).hashCode());
        return result;
    }

    public String toString() {
        return "Layer(layerName=" + this.getLayerName() + ", iDropout=" + this.getIDropout() + ", constraints=" + this.getConstraints() + ")";
    }

    public Layer() {
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String layerName = null;
        protected List<LayerConstraint> allParamConstraints;
        protected List<LayerConstraint> weightConstraints;
        protected List<LayerConstraint> biasConstraints;
        protected IDropout iDropout;

        public T name(String layerName) {
            this.layerName = layerName;
            return (T)this;
        }

        public T dropOut(double inputRetainProbability) {
            if (inputRetainProbability == 0.0) {
                return this.dropOut(null);
            }
            return this.dropOut(new Dropout(inputRetainProbability));
        }

        public T dropOut(IDropout dropout) {
            this.iDropout = dropout;
            return (T)this;
        }

        public T constrainAllParameters(LayerConstraint ... constraints) {
            this.allParamConstraints = Arrays.asList(constraints);
            return (T)this;
        }

        public T constrainBias(LayerConstraint ... constraints) {
            this.biasConstraints = Arrays.asList(constraints);
            return (T)this;
        }

        public T constrainWeights(LayerConstraint ... constraints) {
            this.weightConstraints = Arrays.asList(constraints);
            return (T)this;
        }

        public abstract <E extends Layer> E build();
    }
}

