/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.feedforward.autoencoder;

import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.layers.BasePretrainNetwork;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;

public class AutoEncoder
extends BasePretrainNetwork<org.deeplearning4j.nn.conf.layers.AutoEncoder> {
    public AutoEncoder(NeuralNetConfiguration conf, DataType dataType) {
        super(conf, dataType);
    }

    @Override
    public Pair<INDArray, INDArray> sampleHiddenGivenVisible(INDArray v) {
        this.setInput(v, LayerWorkspaceMgr.noWorkspaces());
        INDArray ret = this.encode(v, true, LayerWorkspaceMgr.noWorkspaces());
        return new Pair((Object)ret, (Object)ret);
    }

    @Override
    public Pair<INDArray, INDArray> sampleVisibleGivenHidden(INDArray h) {
        INDArray ret = this.decode(h, LayerWorkspaceMgr.noWorkspaces());
        return new Pair((Object)ret, (Object)ret);
    }

    public INDArray encode(INDArray v, boolean training, LayerWorkspaceMgr workspaceMgr) {
        INDArray W = this.getParamWithNoise("W", training, workspaceMgr);
        INDArray hBias = this.getParamWithNoise("b", training, workspaceMgr);
        INDArray ret = workspaceMgr.createUninitialized(ArrayType.ACTIVATIONS, W.dataType(), new long[]{v.size(0), W.size(1)});
        INDArray preAct = v.castTo(W.dataType()).mmuli(W, ret).addiRowVector(hBias);
        ret = ((org.deeplearning4j.nn.conf.layers.AutoEncoder)this.layerConf()).getActivationFn().getActivation(preAct, training);
        return workspaceMgr.leverageTo(ArrayType.ACTIVATIONS, ret);
    }

    public INDArray decode(INDArray y, LayerWorkspaceMgr workspaceMgr) {
        INDArray W = this.getParamWithNoise("W", true, workspaceMgr);
        INDArray vBias = this.getParamWithNoise("vb", true, workspaceMgr);
        INDArray preAct = y.mmul(W.transpose()).addiRowVector(vBias);
        return workspaceMgr.leverageTo(ArrayType.ACTIVATIONS, ((org.deeplearning4j.nn.conf.layers.AutoEncoder)this.layerConf()).getActivationFn().getActivation(preAct, true));
    }

    @Override
    public INDArray activate(INDArray input, boolean training, LayerWorkspaceMgr workspaceMgr) {
        this.setInput(input, workspaceMgr);
        return this.encode(input, training, workspaceMgr);
    }

    @Override
    public boolean isPretrainLayer() {
        return true;
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        return this.encode(this.input, training, workspaceMgr);
    }

    @Override
    public void computeGradientAndScore(LayerWorkspaceMgr workspaceMgr) {
        INDArray W = this.getParamWithNoise("W", true, workspaceMgr);
        INDArray input = this.input.castTo(this.dataType);
        double corruptionLevel = ((org.deeplearning4j.nn.conf.layers.AutoEncoder)this.layerConf()).getCorruptionLevel();
        INDArray corruptedX = corruptionLevel > 0.0 ? this.getCorruptedInput(input, corruptionLevel) : input;
        this.setInput(corruptedX, workspaceMgr);
        INDArray y = this.encode(corruptedX, true, workspaceMgr);
        INDArray z = this.decode(y, workspaceMgr);
        INDArray visibleLoss = input.sub(z);
        INDArray hiddenLoss = ((org.deeplearning4j.nn.conf.layers.AutoEncoder)this.layerConf()).getSparsity() == 0.0 ? visibleLoss.mmul(W).muli(y).muli(y.rsub((Number)1)) : visibleLoss.mmul(W).muli(y).muli(y.add((Number)(-((org.deeplearning4j.nn.conf.layers.AutoEncoder)this.layerConf()).getSparsity())));
        INDArray wGradient = corruptedX.transpose().mmul(hiddenLoss).addi(visibleLoss.transpose().mmul(y));
        INDArray hBiasGradient = hiddenLoss.sum(new int[]{0});
        INDArray vBiasGradient = visibleLoss.sum(new int[]{0});
        this.gradient = this.createGradient(wGradient, vBiasGradient, hBiasGradient);
        this.setScoreWithZ(z);
    }
}

