/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.adapters;

import org.nd4j.adapters.OutputAdapter;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class ArgmaxAdapter
implements OutputAdapter<int[]> {
    public int[] apply(INDArray ... outputs) {
        int[] result;
        Preconditions.checkArgument((outputs.length == 1 ? 1 : 0) != 0, (String)"Argmax adapter can have only 1 output");
        INDArray array = outputs[0];
        Preconditions.checkArgument((array.rank() < 3 ? 1 : 0) != 0, (String)"Argmax adapter requires 2D or 1D output");
        int[] nArray = result = array.rank() == 2 ? new int[(int)array.size(0)] : new int[1];
        if (array.rank() == 2) {
            INDArray t = Nd4j.argMax((INDArray)array, (int[])new int[]{1});
            int e = 0;
            while ((long)e < t.length()) {
                result[e] = (int)t.getDouble((long)e);
                ++e;
            }
        } else {
            result[0] = (int)Nd4j.argMax((INDArray)array, (int[])new int[]{Integer.MAX_VALUE}).getDouble(0L);
        }
        return result;
    }
}

