/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize.solvers;

import java.util.Collection;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.optimize.api.StepFunction;
import org.deeplearning4j.optimize.api.TerminationCondition;
import org.deeplearning4j.optimize.solvers.BaseOptimizer;
import org.nd4j.linalg.api.ndarray.INDArray;

public class StochasticGradientDescent
extends BaseOptimizer {
    public StochasticGradientDescent(NeuralNetConfiguration conf, StepFunction stepFunction, Collection<IterationListener> iterationListeners, Model model) {
        super(conf, stepFunction, iterationListeners, model);
    }

    public StochasticGradientDescent(NeuralNetConfiguration conf, StepFunction stepFunction, Collection<IterationListener> iterationListeners, Collection<TerminationCondition> terminationConditions, Model model) {
        super(conf, stepFunction, iterationListeners, terminationConditions, model);
    }

    @Override
    public boolean optimize() {
        for (int i = 0; i < this.conf.getNumIterations(); ++i) {
            Pair<Gradient, Double> pair = this.gradientAndScore();
            Gradient gradient = pair.getFirst();
            INDArray params = this.model.params();
            this.stepFunction.step(params, gradient.gradient());
            this.model.setParams(params);
            for (IterationListener listener : this.iterationListeners) {
                listener.iterationDone(this.model, i);
            }
            this.checkTerminalConditions(pair.getFirst().gradient(), this.oldScore, this.score, i);
            BaseOptimizer.incrementIterationCount(this.model, 1);
        }
        return true;
    }

    @Override
    public void preProcessLine() {
    }

    @Override
    public void postStep(INDArray gradient) {
    }
}

