/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.sequencevectors.transformers.impl;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import org.deeplearning4j.models.sequencevectors.sequence.Sequence;
import org.deeplearning4j.models.sequencevectors.transformers.SequenceTransformer;
import org.deeplearning4j.models.sequencevectors.transformers.impl.iterables.BasicTransformerIterator;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.deeplearning4j.text.documentiterator.BasicLabelAwareIterator;
import org.deeplearning4j.text.documentiterator.DocumentIterator;
import org.deeplearning4j.text.documentiterator.LabelAwareIterator;
import org.deeplearning4j.text.sentenceiterator.SentenceIterator;
import org.deeplearning4j.text.tokenization.tokenizer.Tokenizer;
import org.deeplearning4j.text.tokenization.tokenizerfactory.TokenizerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentenceTransformer
implements SequenceTransformer<VocabWord, String>,
Iterable<Sequence<VocabWord>> {
    protected TokenizerFactory tokenizerFactory;
    protected LabelAwareIterator iterator;
    protected boolean readOnly = false;
    protected AtomicInteger sentenceCounter = new AtomicInteger(0);
    protected boolean allowMultithreading = false;
    protected BasicTransformerIterator currentIterator;
    protected static final Logger log = LoggerFactory.getLogger(SentenceTransformer.class);

    private SentenceTransformer(@NonNull LabelAwareIterator iterator) {
        if (iterator == null) {
            throw new NullPointerException("iterator is marked @NonNull but is null");
        }
        this.iterator = iterator;
    }

    @Override
    public Sequence<VocabWord> transformToSequence(String object) {
        Sequence<VocabWord> sequence = new Sequence<VocabWord>();
        Tokenizer tokenizer = this.tokenizerFactory.create(object);
        List<String> list = tokenizer.getTokens();
        for (String token : list) {
            if (token == null || token.isEmpty() || token.trim().isEmpty()) continue;
            VocabWord word = new VocabWord(1.0, token);
            sequence.addElement(word);
        }
        sequence.setSequenceId(this.sentenceCounter.getAndIncrement());
        return sequence;
    }

    @Override
    public Iterator<Sequence<VocabWord>> iterator() {
        if (this.currentIterator == null) {
            this.currentIterator = new BasicTransformerIterator(this.iterator, this);
        } else {
            this.reset();
        }
        return this.currentIterator;
    }

    @Override
    public void reset() {
        if (this.currentIterator != null) {
            this.currentIterator.reset();
        }
    }

    public static class Builder {
        protected TokenizerFactory tokenizerFactory;
        protected LabelAwareIterator iterator;
        protected VocabCache<VocabWord> vocabCache;
        protected boolean readOnly = false;
        protected boolean allowMultithreading = false;

        public Builder tokenizerFactory(@NonNull TokenizerFactory tokenizerFactory) {
            if (tokenizerFactory == null) {
                throw new NullPointerException("tokenizerFactory is marked @NonNull but is null");
            }
            this.tokenizerFactory = tokenizerFactory;
            return this;
        }

        public Builder iterator(@NonNull LabelAwareIterator iterator) {
            if (iterator == null) {
                throw new NullPointerException("iterator is marked @NonNull but is null");
            }
            this.iterator = iterator;
            return this;
        }

        public Builder iterator(@NonNull SentenceIterator iterator) {
            if (iterator == null) {
                throw new NullPointerException("iterator is marked @NonNull but is null");
            }
            this.iterator = new BasicLabelAwareIterator.Builder(iterator).build();
            return this;
        }

        public Builder iterator(@NonNull DocumentIterator iterator) {
            if (iterator == null) {
                throw new NullPointerException("iterator is marked @NonNull but is null");
            }
            this.iterator = new BasicLabelAwareIterator.Builder(iterator).build();
            return this;
        }

        public Builder readOnly(boolean readOnly) {
            this.readOnly = true;
            return this;
        }

        public Builder allowMultithreading(boolean reallyAllow) {
            this.allowMultithreading = reallyAllow;
            return this;
        }

        public SentenceTransformer build() {
            SentenceTransformer transformer = new SentenceTransformer(this.iterator);
            transformer.tokenizerFactory = this.tokenizerFactory;
            transformer.readOnly = this.readOnly;
            transformer.allowMultithreading = this.allowMultithreading;
            return transformer;
        }
    }
}

