/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.bagofwords.vectorizer;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.deeplearning4j.bagofwords.vectorizer.BaseTextVectorizer;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.deeplearning4j.models.word2vec.wordstore.inmemory.AbstractCache;
import org.deeplearning4j.text.documentiterator.DocumentIterator;
import org.deeplearning4j.text.documentiterator.LabelAwareIterator;
import org.deeplearning4j.text.documentiterator.LabelsSource;
import org.deeplearning4j.text.documentiterator.interoperability.DocumentIteratorConverter;
import org.deeplearning4j.text.sentenceiterator.SentenceIterator;
import org.deeplearning4j.text.sentenceiterator.interoperability.SentenceIteratorConverter;
import org.deeplearning4j.text.tokenization.tokenizer.Tokenizer;
import org.deeplearning4j.text.tokenization.tokenizerfactory.TokenizerFactory;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.FeatureUtil;

public class BagOfWordsVectorizer
extends BaseTextVectorizer {
    protected BagOfWordsVectorizer() {
    }

    @Override
    public DataSet vectorize(InputStream is, String label) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String line = "";
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            return this.vectorize(builder.toString(), label);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DataSet vectorize(String text, String label) {
        INDArray input = this.transform(text);
        INDArray labelMatrix = FeatureUtil.toOutcomeVector((long)this.labelsSource.indexOf(label), (long)this.labelsSource.size());
        return new DataSet(input, labelMatrix);
    }

    @Override
    public INDArray transform(String text) {
        Tokenizer tokenizer = this.tokenizerFactory.create(text);
        List<String> tokens = tokenizer.getTokens();
        return this.transform(tokens);
    }

    @Override
    public INDArray transform(List<String> tokens) {
        INDArray input = Nd4j.create((int)1, (int)this.vocabCache.numWords());
        for (String token : tokens) {
            int idx = this.vocabCache.indexOf(token);
            if (this.vocabCache.indexOf(token) < 0) continue;
            input.putScalar((long)idx, this.vocabCache.wordFrequency(token));
        }
        return input;
    }

    @Override
    public DataSet vectorize(File input, String label) {
        try {
            String string = FileUtils.readFileToString((File)input);
            return this.vectorize(string, label);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public DataSet vectorize() {
        throw new UnsupportedOperationException("Can't vectorize empty input");
    }

    public static class Builder {
        protected TokenizerFactory tokenizerFactory;
        protected LabelAwareIterator iterator;
        protected int minWordFrequency;
        protected VocabCache<VocabWord> vocabCache;
        protected LabelsSource labelsSource = new LabelsSource();
        protected Collection<String> stopWords = new ArrayList<String>();
        protected boolean isParallel = true;

        public Builder allowParallelTokenization(boolean reallyAllow) {
            this.isParallel = reallyAllow;
            return this;
        }

        public Builder setTokenizerFactory(@NonNull TokenizerFactory tokenizerFactory) {
            if (tokenizerFactory == null) {
                throw new NullPointerException("tokenizerFactory is marked @NonNull but is null");
            }
            this.tokenizerFactory = tokenizerFactory;
            return this;
        }

        public Builder setIterator(@NonNull LabelAwareIterator iterator) {
            if (iterator == null) {
                throw new NullPointerException("iterator is marked @NonNull but is null");
            }
            this.iterator = iterator;
            return this;
        }

        public Builder setIterator(@NonNull DocumentIterator iterator) {
            if (iterator == null) {
                throw new NullPointerException("iterator is marked @NonNull but is null");
            }
            this.iterator = new DocumentIteratorConverter(iterator, this.labelsSource);
            return this;
        }

        public Builder setIterator(@NonNull SentenceIterator iterator) {
            if (iterator == null) {
                throw new NullPointerException("iterator is marked @NonNull but is null");
            }
            this.iterator = new SentenceIteratorConverter(iterator, this.labelsSource);
            return this;
        }

        public Builder setVocab(@NonNull VocabCache<VocabWord> vocab) {
            if (vocab == null) {
                throw new NullPointerException("vocab is marked @NonNull but is null");
            }
            this.vocabCache = vocab;
            return this;
        }

        public Builder setMinWordFrequency(int minWordFrequency) {
            this.minWordFrequency = minWordFrequency;
            return this;
        }

        public Builder setStopWords(Collection<String> stopWords) {
            this.stopWords = stopWords;
            return this;
        }

        public BagOfWordsVectorizer build() {
            BagOfWordsVectorizer vectorizer = new BagOfWordsVectorizer();
            vectorizer.tokenizerFactory = this.tokenizerFactory;
            vectorizer.iterator = this.iterator;
            vectorizer.minWordFrequency = this.minWordFrequency;
            vectorizer.labelsSource = this.labelsSource;
            vectorizer.stopWords = this.stopWords;
            vectorizer.isParallel = this.isParallel;
            if (this.vocabCache == null) {
                this.vocabCache = new AbstractCache.Builder().build();
            }
            vectorizer.vocabCache = this.vocabCache;
            return vectorizer;
        }
    }
}

