/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.word2vec.wordstore.inmemory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractCache<T extends SequenceElement>
implements VocabCache<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractCache.class);
    private final ConcurrentMap<Long, T> vocabulary = new ConcurrentHashMap<Long, T>();
    private final Map<String, T> extendedVocabulary = new ConcurrentHashMap<String, T>();
    private final Map<Integer, T> idxMap = new ConcurrentHashMap<Integer, T>();
    private final AtomicLong documentsCounter = new AtomicLong(0L);
    private int minWordFrequency = 0;
    private boolean hugeModelExpected = false;
    private List<String> stopWords = new ArrayList<String>();
    private int scavengerThreshold = 3000000;
    private int retentionDelay = 3;
    private transient AtomicLong hiddenWordsCounter = new AtomicLong(0L);
    private final AtomicLong totalWordCount = new AtomicLong(0L);
    private static final int MAX_CODE_LENGTH = 40;

    @Override
    public void loadVocab() {
    }

    @Override
    public boolean vocabExists() {
        return !this.vocabulary.isEmpty();
    }

    @Override
    public void saveVocab() {
    }

    @Override
    public Collection<String> words() {
        return Collections.unmodifiableCollection(this.extendedVocabulary.keySet());
    }

    @Override
    public void incrementWordCount(String word) {
        this.incrementWordCount(word, 1);
    }

    @Override
    public void incrementWordCount(String word, int increment) {
        SequenceElement element = (SequenceElement)this.extendedVocabulary.get(word);
        if (element != null) {
            element.increaseElementFrequency(increment);
            this.totalWordCount.addAndGet(increment);
        }
    }

    @Override
    public int wordFrequency(@NonNull String word) {
        if (word == null) {
            throw new NullPointerException("word is marked @NonNull but is null");
        }
        SequenceElement element = (SequenceElement)this.extendedVocabulary.get(word);
        if (element != null) {
            return (int)element.getElementFrequency();
        }
        return 0;
    }

    @Override
    public boolean containsWord(String word) {
        return this.extendedVocabulary.containsKey(word);
    }

    public boolean containsElement(T element) {
        return this.vocabulary.values().contains(element);
    }

    @Override
    public String wordAtIndex(int index) {
        SequenceElement element = (SequenceElement)this.idxMap.get(index);
        if (element != null) {
            return element.getLabel();
        }
        return null;
    }

    @Override
    public T elementAtIndex(int index) {
        return (T)((SequenceElement)this.idxMap.get(index));
    }

    @Override
    public int indexOf(String label) {
        T token = this.tokenFor(label);
        if (token != null) {
            return ((SequenceElement)token).getIndex();
        }
        return -2;
    }

    @Override
    public Collection<T> vocabWords() {
        return this.vocabulary.values();
    }

    @Override
    public long totalWordOccurrences() {
        return this.totalWordCount.get();
    }

    public void setTotalWordOccurences(long value) {
        this.totalWordCount.set(value);
    }

    @Override
    public T wordFor(@NonNull String label) {
        if (label == null) {
            throw new NullPointerException("label is marked @NonNull but is null");
        }
        return (T)((SequenceElement)this.extendedVocabulary.get(label));
    }

    @Override
    public T wordFor(long id) {
        return (T)((SequenceElement)this.vocabulary.get(id));
    }

    @Override
    public void addWordToIndex(int index, String label) {
        T token;
        if (index >= 0 && (token = this.tokenFor(label)) != null) {
            this.idxMap.put(index, token);
            ((SequenceElement)token).setIndex(index);
        }
    }

    @Override
    public void addWordToIndex(int index, long elementId) {
        if (index >= 0) {
            this.idxMap.put(index, this.tokenFor(elementId));
        }
    }

    @Override
    @Deprecated
    public void putVocabWord(String word) {
        if (!this.containsWord(word)) {
            throw new IllegalStateException("Specified label is not present in vocabulary");
        }
    }

    @Override
    public int numWords() {
        return this.vocabulary.size();
    }

    @Override
    public int docAppearedIn(String word) {
        SequenceElement element = (SequenceElement)this.extendedVocabulary.get(word);
        if (element != null) {
            return (int)element.getSequencesCount();
        }
        return -1;
    }

    @Override
    public void incrementDocCount(String word, long howMuch) {
        SequenceElement element = (SequenceElement)this.extendedVocabulary.get(word);
        if (element != null) {
            element.incrementSequencesCount();
        }
    }

    @Override
    public void setCountForDoc(String word, long count) {
        SequenceElement element = (SequenceElement)this.extendedVocabulary.get(word);
        if (element != null) {
            element.setSequencesCount(count);
        }
    }

    @Override
    public long totalNumberOfDocs() {
        return this.documentsCounter.intValue();
    }

    @Override
    public void incrementTotalDocCount() {
        this.documentsCounter.incrementAndGet();
    }

    @Override
    public void incrementTotalDocCount(long by) {
        this.documentsCounter.addAndGet(by);
    }

    public void setTotalDocCount(long by) {
        this.documentsCounter.set(by);
    }

    @Override
    public Collection<T> tokens() {
        return this.vocabWords();
    }

    @Override
    public void addToken(T element) {
        SequenceElement oldElement = (SequenceElement)this.vocabulary.putIfAbsent(((SequenceElement)element).getStorageId(), element);
        if (oldElement == null) {
            if (((SequenceElement)element).getLabel() != null) {
                this.extendedVocabulary.put(((SequenceElement)element).getLabel(), element);
            }
            oldElement = element;
        } else {
            oldElement.incrementSequencesCount(((SequenceElement)element).getSequencesCount());
            oldElement.increaseElementFrequency((int)((SequenceElement)element).getElementFrequency());
        }
        this.totalWordCount.addAndGet((long)oldElement.getElementFrequency());
    }

    @Override
    public T tokenFor(String label) {
        return this.wordFor(label);
    }

    @Override
    public T tokenFor(long id) {
        return (T)((SequenceElement)this.vocabulary.get(id));
    }

    @Override
    public boolean hasToken(String label) {
        return this.containsWord(label);
    }

    @Override
    public void importVocabulary(@NonNull VocabCache<T> vocabCache) {
        if (vocabCache == null) {
            throw new NullPointerException("vocabCache is marked @NonNull but is null");
        }
        for (SequenceElement element : vocabCache.vocabWords()) {
            this.addToken(element);
        }
        this.documentsCounter.addAndGet(vocabCache.totalNumberOfDocs());
    }

    @Override
    public void updateWordsOccurrences() {
        this.totalWordCount.set(0L);
        for (SequenceElement element : this.vocabulary.values()) {
            long value = (long)element.getElementFrequency();
            if (value <= 0L) continue;
            this.totalWordCount.addAndGet(value);
        }
        log.info("Updated counter: [" + this.totalWordCount.get() + "]");
    }

    @Override
    public void removeElement(String label) {
        SequenceElement element = (SequenceElement)this.extendedVocabulary.get(label);
        if (element == null) {
            throw new IllegalStateException("Can't get label: '" + label + "'");
        }
        this.totalWordCount.getAndAdd((long)element.getElementFrequency() * -1L);
        this.idxMap.remove(element.getIndex());
        this.extendedVocabulary.remove(label);
        this.vocabulary.remove(element.getStorageId());
    }

    @Override
    public void removeElement(T element) {
        this.removeElement(((SequenceElement)element).getLabel());
    }

    public static class Builder<T extends SequenceElement> {
        protected int scavengerThreshold = 3000000;
        protected int retentionDelay = 3;
        protected int minElementFrequency;
        protected boolean hugeModelExpected = false;

        public Builder<T> hugeModelExpected(boolean reallyExpected) {
            this.hugeModelExpected = reallyExpected;
            return this;
        }

        public Builder<T> scavengerThreshold(int threshold) {
            this.scavengerThreshold = threshold;
            return this;
        }

        public Builder<T> scavengerRetentionDelay(int delay) {
            this.retentionDelay = delay;
            return this;
        }

        public Builder<T> minElementFrequency(int minFrequency) {
            this.minElementFrequency = minFrequency;
            return this;
        }

        public AbstractCache<T> build() {
            AbstractCache cache = new AbstractCache();
            cache.minWordFrequency = this.minElementFrequency;
            cache.scavengerThreshold = this.scavengerThreshold;
            cache.retentionDelay = this.retentionDelay;
            return cache;
        }
    }
}

