/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.embeddings.reader.impl;

import java.util.Collection;
import org.deeplearning4j.models.embeddings.reader.impl.BasicModelUtils;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.nd4j.linalg.primitives.Counter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlatModelUtils<T extends SequenceElement>
extends BasicModelUtils<T> {
    private static final Logger log = LoggerFactory.getLogger(FlatModelUtils.class);

    @Override
    public Collection<String> wordsNearest(String label, int n) {
        Collection<String> collection = this.wordsNearest(this.lookupTable.vector(label), n);
        if (collection.contains(label)) {
            collection.remove(label);
        }
        return collection;
    }

    @Override
    public Collection<String> wordsNearest(INDArray words, int top) {
        Counter distances = new Counter();
        for (String s : this.vocabCache.words()) {
            INDArray otherVec = this.lookupTable.vector(s);
            double sim = Transforms.cosineSim((INDArray)Transforms.unitVec((INDArray)words.dup()), (INDArray)Transforms.unitVec((INDArray)otherVec.dup()));
            distances.incrementCount((Object)s, (double)((float)sim));
        }
        distances.keepTopNElements(top);
        return distances.keySetSorted();
    }
}

