/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.inputsanitation;

import java.text.Normalizer;
import java.util.List;

public class InputHomogenization {
    private String input;
    private List<String> ignoreCharactersContaining;
    private boolean preserveCase;

    public InputHomogenization(String input) {
        this(input, false);
    }

    public InputHomogenization(String input, boolean preserveCase) {
        this.input = input;
        this.preserveCase = preserveCase;
    }

    public InputHomogenization(String input, List<String> ignoreCharactersContaining) {
        this.input = input;
        this.ignoreCharactersContaining = ignoreCharactersContaining;
    }

    public String transform() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.input.length(); ++i) {
            if (this.ignoreCharactersContaining != null && this.ignoreCharactersContaining.contains(String.valueOf(this.input.charAt(i)))) {
                sb.append(this.input.charAt(i));
                continue;
            }
            if (Character.isDigit(this.input.charAt(i))) {
                sb.append("d");
                continue;
            }
            if (Character.isUpperCase(this.input.charAt(i)) && !this.preserveCase) {
                sb.append(Character.toLowerCase(this.input.charAt(i)));
                continue;
            }
            sb.append(this.input.charAt(i));
        }
        String normalized = Normalizer.normalize(sb.toString(), Normalizer.Form.NFD);
        normalized = normalized.replace(".", "");
        normalized = normalized.replace(",", "");
        normalized = normalized.replaceAll("\"", "");
        normalized = normalized.replace("'", "");
        normalized = normalized.replace("(", "");
        normalized = normalized.replace(")", "");
        normalized = normalized.replace("\u201c", "");
        normalized = normalized.replace("\u201d", "");
        normalized = normalized.replace("\u2026", "");
        normalized = normalized.replace("|", "");
        normalized = normalized.replace("/", "");
        normalized = normalized.replace("\\", "");
        normalized = normalized.replace("[", "");
        normalized = normalized.replace("]", "");
        normalized = normalized.replace("\u2018", "");
        normalized = normalized.replace("\u2019", "");
        normalized = normalized.replaceAll("[!]+", "!");
        return normalized;
    }
}

