/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.word2vec.wordstore.inmemory;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.nd4j.shade.jackson.annotation.JsonAutoDetect;
import org.nd4j.shade.jackson.annotation.JsonTypeInfo;
import org.nd4j.shade.jackson.core.JsonProcessingException;
import org.nd4j.shade.jackson.databind.DeserializationFeature;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.nd4j.shade.jackson.databind.SerializationFeature;
import org.nd4j.shade.jackson.databind.type.CollectionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class AbstractCache<T extends SequenceElement>
implements VocabCache<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractCache.class);
    private static final String CLASS_FIELD = "@class";
    private static final String VOCAB_LIST_FIELD = "VocabList";
    private static final String VOCAB_ITEM_FIELD = "VocabItem";
    private static final String DOC_CNT_FIELD = "DocumentsCounter";
    private static final String MINW_FREQ_FIELD = "MinWordsFrequency";
    private static final String HUGE_MODEL_FIELD = "HugeModelExpected";
    private static final String STOP_WORDS_FIELD = "StopWords";
    private static final String SCAVENGER_FIELD = "ScavengerThreshold";
    private static final String RETENTION_FIELD = "RetentionDelay";
    private static final String TOTAL_WORD_FIELD = "TotalWordCount";
    private final ConcurrentMap<Long, T> vocabulary = new ConcurrentHashMap<Long, T>();
    private final Map<String, T> extendedVocabulary = new ConcurrentHashMap<String, T>();
    private final Map<Integer, T> idxMap = new ConcurrentHashMap<Integer, T>();
    private final AtomicLong documentsCounter = new AtomicLong(0L);
    private int minWordFrequency = 0;
    private boolean hugeModelExpected = false;
    private List<String> stopWords = new ArrayList<String>();
    private int scavengerThreshold = 3000000;
    private int retentionDelay = 3;
    private transient AtomicLong hiddenWordsCounter = new AtomicLong(0L);
    private final AtomicLong totalWordCount = new AtomicLong(0L);
    private static final int MAX_CODE_LENGTH = 40;
    private static ObjectMapper mapper = null;
    private static final Object lock = new Object();

    @Override
    public void loadVocab() {
    }

    @Override
    public boolean vocabExists() {
        return !this.vocabulary.isEmpty();
    }

    @Override
    public void saveVocab() {
    }

    @Override
    public Collection<String> words() {
        return Collections.unmodifiableCollection(this.extendedVocabulary.keySet());
    }

    @Override
    public void incrementWordCount(String word) {
        this.incrementWordCount(word, 1);
    }

    @Override
    public void incrementWordCount(String word, int increment) {
        SequenceElement element = (SequenceElement)this.extendedVocabulary.get(word);
        if (element != null) {
            element.increaseElementFrequency(increment);
            this.totalWordCount.addAndGet(increment);
        }
    }

    @Override
    public int wordFrequency(@NonNull String word) {
        if (word == null) {
            throw new NullPointerException("word is marked non-null but is null");
        }
        SequenceElement element = (SequenceElement)this.extendedVocabulary.get(word);
        if (element != null) {
            return (int)element.getElementFrequency();
        }
        return 0;
    }

    @Override
    public boolean containsWord(String word) {
        return this.extendedVocabulary.containsKey(word);
    }

    public boolean containsElement(T element) {
        return this.vocabulary.values().contains(element);
    }

    @Override
    public String wordAtIndex(int index) {
        SequenceElement element = (SequenceElement)this.idxMap.get(index);
        if (element != null) {
            return element.getLabel();
        }
        return null;
    }

    @Override
    public T elementAtIndex(int index) {
        return (T)((SequenceElement)this.idxMap.get(index));
    }

    @Override
    public int indexOf(String label) {
        T token = this.tokenFor(label);
        if (token != null) {
            return ((SequenceElement)token).getIndex();
        }
        return -2;
    }

    @Override
    public Collection<T> vocabWords() {
        return this.vocabulary.values();
    }

    @Override
    public long totalWordOccurrences() {
        return this.totalWordCount.get();
    }

    public void setTotalWordOccurences(long value) {
        this.totalWordCount.set(value);
    }

    @Override
    public T wordFor(@NonNull String label) {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        return (T)((SequenceElement)this.extendedVocabulary.get(label));
    }

    @Override
    public T wordFor(long id) {
        return (T)((SequenceElement)this.vocabulary.get(id));
    }

    @Override
    public void addWordToIndex(int index, String label) {
        T token;
        if (index >= 0 && (token = this.tokenFor(label)) != null) {
            this.idxMap.put(index, token);
            ((SequenceElement)token).setIndex(index);
        }
    }

    @Override
    public void addWordToIndex(int index, long elementId) {
        if (index >= 0) {
            this.idxMap.put(index, this.tokenFor(elementId));
        }
    }

    @Override
    @Deprecated
    public void putVocabWord(String word) {
        if (!this.containsWord(word)) {
            throw new IllegalStateException("Specified label is not present in vocabulary");
        }
    }

    @Override
    public int numWords() {
        return this.vocabulary.size();
    }

    @Override
    public int docAppearedIn(String word) {
        SequenceElement element = (SequenceElement)this.extendedVocabulary.get(word);
        if (element != null) {
            return (int)element.getSequencesCount();
        }
        return -1;
    }

    @Override
    public void incrementDocCount(String word, long howMuch) {
        SequenceElement element = (SequenceElement)this.extendedVocabulary.get(word);
        if (element != null) {
            element.incrementSequencesCount();
        }
    }

    @Override
    public void setCountForDoc(String word, long count) {
        SequenceElement element = (SequenceElement)this.extendedVocabulary.get(word);
        if (element != null) {
            element.setSequencesCount(count);
        }
    }

    @Override
    public long totalNumberOfDocs() {
        return this.documentsCounter.intValue();
    }

    @Override
    public void incrementTotalDocCount() {
        this.documentsCounter.incrementAndGet();
    }

    @Override
    public void incrementTotalDocCount(long by) {
        this.documentsCounter.addAndGet(by);
    }

    public void setTotalDocCount(long by) {
        this.documentsCounter.set(by);
    }

    @Override
    public Collection<T> tokens() {
        return this.vocabWords();
    }

    @Override
    public boolean addToken(T element) {
        boolean ret = false;
        SequenceElement oldElement = (SequenceElement)this.vocabulary.putIfAbsent(((SequenceElement)element).getStorageId(), element);
        if (oldElement == null) {
            if (((SequenceElement)element).getLabel() != null) {
                this.extendedVocabulary.put(((SequenceElement)element).getLabel(), element);
            }
            oldElement = element;
            ret = true;
        } else {
            oldElement.incrementSequencesCount(((SequenceElement)element).getSequencesCount());
            oldElement.increaseElementFrequency((int)((SequenceElement)element).getElementFrequency());
        }
        this.totalWordCount.addAndGet((long)oldElement.getElementFrequency());
        return ret;
    }

    public void addToken(T element, boolean lockf) {
        SequenceElement oldElement = (SequenceElement)this.vocabulary.putIfAbsent(((SequenceElement)element).getStorageId(), element);
        if (oldElement == null) {
            if (((SequenceElement)element).getLabel() != null) {
                this.extendedVocabulary.put(((SequenceElement)element).getLabel(), element);
            }
            oldElement = element;
        } else {
            oldElement.incrementSequencesCount(((SequenceElement)element).getSequencesCount());
            oldElement.increaseElementFrequency((int)((SequenceElement)element).getElementFrequency());
        }
        this.totalWordCount.addAndGet((long)oldElement.getElementFrequency());
    }

    @Override
    public T tokenFor(String label) {
        return this.wordFor(label);
    }

    @Override
    public T tokenFor(long id) {
        return (T)((SequenceElement)this.vocabulary.get(id));
    }

    @Override
    public boolean hasToken(String label) {
        return this.containsWord(label);
    }

    @Override
    public void importVocabulary(@NonNull VocabCache<T> vocabCache) {
        if (vocabCache == null) {
            throw new NullPointerException("vocabCache is marked non-null but is null");
        }
        AtomicBoolean added = new AtomicBoolean(false);
        for (SequenceElement element : vocabCache.vocabWords()) {
            if (!this.addToken(element)) continue;
            added.set(true);
        }
        if (added.get()) {
            this.documentsCounter.addAndGet(vocabCache.totalNumberOfDocs());
        }
    }

    @Override
    public void updateWordsOccurrences() {
        this.totalWordCount.set(0L);
        for (SequenceElement element : this.vocabulary.values()) {
            long value = (long)element.getElementFrequency();
            if (value <= 0L) continue;
            this.totalWordCount.addAndGet(value);
        }
        log.info("Updated counter: [" + this.totalWordCount.get() + "]");
    }

    @Override
    public void removeElement(String label) {
        SequenceElement element = (SequenceElement)this.extendedVocabulary.get(label);
        if (element == null) {
            throw new IllegalStateException("Can't get label: '" + label + "'");
        }
        this.totalWordCount.getAndAdd((long)element.getElementFrequency() * -1L);
        this.idxMap.remove(element.getIndex());
        this.extendedVocabulary.remove(label);
        this.vocabulary.remove(element.getStorageId());
    }

    @Override
    public void removeElement(T element) {
        this.removeElement(((SequenceElement)element).getLabel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ObjectMapper mapper() {
        if (mapper == null) {
            Object object = lock;
            synchronized (object) {
                if (mapper == null) {
                    mapper = new ObjectMapper();
                    mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                    mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
                    return mapper;
                }
            }
        }
        return mapper;
    }

    public String toJson() throws JsonProcessingException {
        JsonObject retVal = new JsonObject();
        ObjectMapper mapper = AbstractCache.mapper();
        Iterator iter = this.vocabulary.values().iterator();
        Class<?> clazz = null;
        if (!iter.hasNext()) {
            return retVal.getAsString();
        }
        clazz = ((SequenceElement)iter.next()).getClass();
        retVal.addProperty(CLASS_FIELD, mapper.writeValueAsString((Object)this.getClass().getName()));
        JsonArray jsonValues = new JsonArray();
        for (SequenceElement value : this.vocabulary.values()) {
            JsonObject item = new JsonObject();
            item.addProperty(CLASS_FIELD, mapper.writeValueAsString(clazz));
            item.addProperty(VOCAB_ITEM_FIELD, mapper.writeValueAsString((Object)value));
            jsonValues.add((JsonElement)item);
        }
        retVal.add(VOCAB_LIST_FIELD, (JsonElement)jsonValues);
        retVal.addProperty(DOC_CNT_FIELD, mapper.writeValueAsString((Object)this.documentsCounter.longValue()));
        retVal.addProperty(MINW_FREQ_FIELD, mapper.writeValueAsString((Object)this.minWordFrequency));
        retVal.addProperty(HUGE_MODEL_FIELD, mapper.writeValueAsString((Object)this.hugeModelExpected));
        retVal.addProperty(STOP_WORDS_FIELD, mapper.writeValueAsString(this.stopWords));
        retVal.addProperty(SCAVENGER_FIELD, mapper.writeValueAsString((Object)this.scavengerThreshold));
        retVal.addProperty(RETENTION_FIELD, mapper.writeValueAsString((Object)this.retentionDelay));
        retVal.addProperty(TOTAL_WORD_FIELD, mapper.writeValueAsString((Object)this.totalWordCount.longValue()));
        return retVal.toString();
    }

    public static <T extends SequenceElement> AbstractCache<T> fromJson(String jsonString) throws IOException {
        AbstractCache retVal = new Builder().build();
        JsonParser parser = new JsonParser();
        JsonObject json = parser.parse(jsonString).getAsJsonObject();
        ObjectMapper mapper = AbstractCache.mapper();
        CollectionType wordsCollectionType = mapper.getTypeFactory().constructCollectionType(List.class, VocabWord.class);
        ArrayList<VocabWord> items = new ArrayList<VocabWord>();
        JsonArray jsonArray = json.get(VOCAB_LIST_FIELD).getAsJsonArray();
        for (int i = 0; i < jsonArray.size(); ++i) {
            VocabWord item = (VocabWord)mapper.readValue(jsonArray.get(i).getAsJsonObject().get(VOCAB_ITEM_FIELD).getAsString(), VocabWord.class);
            items.add(item);
        }
        ConcurrentHashMap<Long, SequenceElement> vocabulary = new ConcurrentHashMap<Long, SequenceElement>();
        ConcurrentHashMap<String, SequenceElement> extendedVocabulary = new ConcurrentHashMap<String, SequenceElement>();
        ConcurrentHashMap<Integer, SequenceElement> idxMap = new ConcurrentHashMap<Integer, SequenceElement>();
        for (SequenceElement sequenceElement : items) {
            vocabulary.put(sequenceElement.getStorageId(), sequenceElement);
            extendedVocabulary.put(sequenceElement.getLabel(), sequenceElement);
            idxMap.put(sequenceElement.getIndex(), sequenceElement);
        }
        List stopWords = (List)mapper.readValue(json.get(STOP_WORDS_FIELD).getAsString(), List.class);
        Long l = json.get(DOC_CNT_FIELD).getAsLong();
        Integer minWordsFrequency = json.get(MINW_FREQ_FIELD).getAsInt();
        Boolean hugeModelExpected = json.get(HUGE_MODEL_FIELD).getAsBoolean();
        Integer scavengerThreshold = json.get(SCAVENGER_FIELD).getAsInt();
        Integer retentionDelay = json.get(RETENTION_FIELD).getAsInt();
        Long totalWordCount = json.get(TOTAL_WORD_FIELD).getAsLong();
        retVal.vocabulary.putAll(vocabulary);
        retVal.extendedVocabulary.putAll(extendedVocabulary);
        retVal.idxMap.putAll(idxMap);
        retVal.stopWords.addAll(stopWords);
        retVal.documentsCounter.set(l);
        retVal.minWordFrequency = minWordsFrequency;
        retVal.hugeModelExpected = hugeModelExpected;
        retVal.scavengerThreshold = scavengerThreshold;
        retVal.retentionDelay = retentionDelay;
        retVal.totalWordCount.set(totalWordCount);
        return retVal;
    }

    public static class Builder<T extends SequenceElement> {
        protected int scavengerThreshold = 3000000;
        protected int retentionDelay = 3;
        protected int minElementFrequency;
        protected boolean hugeModelExpected = false;

        public Builder<T> hugeModelExpected(boolean reallyExpected) {
            this.hugeModelExpected = reallyExpected;
            return this;
        }

        public Builder<T> scavengerThreshold(int threshold) {
            this.scavengerThreshold = threshold;
            return this;
        }

        public Builder<T> scavengerRetentionDelay(int delay) {
            this.retentionDelay = delay;
            return this;
        }

        public Builder<T> minElementFrequency(int minFrequency) {
            this.minElementFrequency = minFrequency;
            return this;
        }

        public AbstractCache<T> build() {
            AbstractCache cache = new AbstractCache();
            cache.minWordFrequency = this.minElementFrequency;
            cache.scavengerThreshold = this.scavengerThreshold;
            cache.retentionDelay = this.retentionDelay;
            return cache;
        }
    }
}

