/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.sentenceiterator;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.deeplearning4j.text.sentenceiterator.SentenceIterator;
import org.deeplearning4j.text.sentenceiterator.SentencePreProcessor;

public class BasicResultSetIterator
implements SentenceIterator {
    private ResultSet rs;
    private String columnName;
    private SentencePreProcessor preProcessor;
    private boolean nextCalled;
    private boolean resultOfNext;

    public BasicResultSetIterator(ResultSet rs, String columnName) {
        this.rs = rs;
        this.columnName = columnName;
        this.nextCalled = false;
        this.resultOfNext = false;
    }

    @Override
    public synchronized String nextSentence() {
        try {
            if (!this.nextCalled) {
                this.rs.next();
            } else {
                this.nextCalled = false;
            }
            return this.preProcessor != null ? this.preProcessor.preProcess(this.rs.getString(this.columnName)) : this.rs.getString(this.columnName);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized boolean hasNext() {
        try {
            if (!this.nextCalled) {
                this.resultOfNext = this.rs.next();
                this.nextCalled = true;
            }
            return this.resultOfNext;
        }
        catch (SQLException e) {
            return false;
        }
    }

    @Override
    public synchronized void reset() {
        try {
            this.rs.beforeFirst();
            this.nextCalled = false;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void finish() {
        try {
            this.rs.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public SentencePreProcessor getPreProcessor() {
        return this.preProcessor;
    }

    @Override
    public void setPreProcessor(SentencePreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }
}

