/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.movingwindow;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.deeplearning4j.text.tokenization.tokenizer.Tokenizer;
import org.deeplearning4j.text.tokenization.tokenizerfactory.TokenizerFactory;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.collection.MultiDimensionalMap;
import org.nd4j.common.primitives.Pair;

public class ContextLabelRetriever {
    private static String BEGIN_LABEL = "<([A-Za-z]+|\\d+)>";
    private static String END_LABEL = "</([A-Za-z]+|\\d+)>";

    private ContextLabelRetriever() {
    }

    public static Pair<String, MultiDimensionalMap<Integer, Integer, String>> stringWithLabels(String sentence, TokenizerFactory tokenizerFactory) {
        MultiDimensionalMap map = MultiDimensionalMap.newHashBackedMap();
        Tokenizer t = tokenizerFactory.create(sentence);
        ArrayList<String> currTokens = new ArrayList<String>();
        String currLabel = null;
        String endLabel = null;
        ArrayList<Pair> tokensWithSameLabel = new ArrayList<Pair>();
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            if (token.matches(BEGIN_LABEL)) {
                if (endLabel != null) {
                    throw new IllegalStateException("Tried parsing sentence; found an end label when the begin label has not been cleared");
                }
                currLabel = token;
                if (!currTokens.isEmpty()) {
                    tokensWithSameLabel.add(new Pair((Object)"NONE", new ArrayList(currTokens)));
                    currTokens.clear();
                }
            } else if (token.matches(END_LABEL)) {
                if (currLabel == null) {
                    throw new IllegalStateException("Found an ending label with no matching begin label");
                }
                endLabel = token;
            } else {
                currTokens.add(token);
            }
            if (currLabel == null || endLabel == null) continue;
            currLabel = currLabel.replaceAll("[<>/]", "");
            endLabel = endLabel.replaceAll("[<>/]", "");
            Preconditions.checkState((!currLabel.isEmpty() ? 1 : 0) != 0, (String)"Current label is empty!");
            Preconditions.checkState((!endLabel.isEmpty() ? 1 : 0) != 0, (String)"End label is empty!");
            Preconditions.checkState((boolean)currLabel.equals(endLabel), (String)"Current label begin and end did not match for the parse. Was: %s ending with %s", (Object)currLabel, (Object)endLabel);
            tokensWithSameLabel.add(new Pair((Object)currLabel, new ArrayList(currTokens)));
            currTokens.clear();
            currLabel = null;
            endLabel = null;
        }
        if (!currTokens.isEmpty()) {
            tokensWithSameLabel.add(new Pair((Object)"none", new ArrayList(currTokens)));
            currTokens.clear();
        }
        StringBuilder strippedSentence = new StringBuilder();
        for (Pair tokensWithLabel : tokensWithSameLabel) {
            String joinedSentence = StringUtils.join((Iterable)((Iterable)tokensWithLabel.getSecond()), (String)" ");
            if (strippedSentence.length() >= 1) {
                strippedSentence.append(" ");
            }
            strippedSentence.append(joinedSentence);
            int begin = strippedSentence.toString().indexOf(joinedSentence);
            int end = begin + joinedSentence.length();
            map.put((Object)begin, (Object)end, tokensWithLabel.getFirst());
        }
        return new Pair((Object)strippedSentence.toString(), (Object)map);
    }
}

