/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.documentiterator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import org.deeplearning4j.text.documentiterator.LabelAwareIterator;
import org.deeplearning4j.text.documentiterator.LabelledDocument;
import org.deeplearning4j.text.documentiterator.LabelsSource;

public class FilenamesLabelAwareIterator
implements LabelAwareIterator {
    protected List<File> files;
    protected AtomicInteger position = new AtomicInteger(0);
    protected LabelsSource labelsSource;
    protected boolean absPath = false;

    protected FilenamesLabelAwareIterator() {
    }

    protected FilenamesLabelAwareIterator(@NonNull List<File> files, @NonNull LabelsSource source) {
        if (files == null) {
            throw new NullPointerException("files is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        this.files = files;
        this.labelsSource = source;
    }

    @Override
    public boolean hasNextDocument() {
        return this.position.get() < this.files.size();
    }

    @Override
    public LabelledDocument nextDocument() {
        File fileToRead = this.files.get(this.position.getAndIncrement());
        String label = this.absPath ? fileToRead.getAbsolutePath() : fileToRead.getName();
        this.labelsSource.storeLabel(label);
        try {
            LabelledDocument document = new LabelledDocument();
            BufferedReader reader = new BufferedReader(new FileReader(fileToRead));
            StringBuilder builder = new StringBuilder();
            String line = "";
            while ((line = reader.readLine()) != null) {
                builder.append(line).append(" ");
            }
            document.setContent(builder.toString());
            document.addLabel(label);
            try {
                reader.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return document;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.hasNextDocument();
    }

    @Override
    public LabelledDocument next() {
        return this.nextDocument();
    }

    @Override
    public void remove() {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void reset() {
        this.position.set(0);
    }

    @Override
    public LabelsSource getLabelsSource() {
        return this.labelsSource;
    }

    public static class Builder {
        protected List<File> foldersToScan = new ArrayList<File>();
        private List<File> fileList = new ArrayList<File>();
        private List<String> labels = new ArrayList<String>();
        private boolean absPath = false;

        public Builder addSourceFolder(@NonNull File folder) {
            if (folder == null) {
                throw new NullPointerException("folder is marked non-null but is null");
            }
            this.foldersToScan.add(folder);
            return this;
        }

        public Builder useAbsolutePathAsLabel(boolean reallyUse) {
            this.absPath = reallyUse;
            return this;
        }

        private void scanFolder(File folderToScan) {
            File[] files = folderToScan.listFiles();
            if (files == null || files.length == 0) {
                return;
            }
            for (File fileLabel : files) {
                if (fileLabel.isDirectory()) {
                    this.scanFolder(fileLabel);
                    continue;
                }
                this.fileList.add(fileLabel);
            }
        }

        public FilenamesLabelAwareIterator build() {
            for (File file : this.foldersToScan) {
                if (!file.isDirectory()) continue;
                this.scanFolder(file);
            }
            LabelsSource source = new LabelsSource(this.labels);
            FilenamesLabelAwareIterator iterator = new FilenamesLabelAwareIterator(this.fileList, source);
            iterator.absPath = this.absPath;
            return iterator;
        }
    }
}

