/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.embeddings.learning.impl.sequence;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import org.deeplearning4j.models.embeddings.WeightLookupTable;
import org.deeplearning4j.models.embeddings.inmemory.InMemoryLookupTable;
import org.deeplearning4j.models.embeddings.learning.ElementsLearningAlgorithm;
import org.deeplearning4j.models.embeddings.learning.SequenceLearningAlgorithm;
import org.deeplearning4j.models.embeddings.learning.impl.elements.CBOW;
import org.deeplearning4j.models.embeddings.loader.VectorsConfiguration;
import org.deeplearning4j.models.sequencevectors.interfaces.SequenceIterator;
import org.deeplearning4j.models.sequencevectors.sequence.Sequence;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.rng.Random;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DM<T extends SequenceElement>
implements SequenceLearningAlgorithm<T> {
    private static final Logger log = LoggerFactory.getLogger(DM.class);
    private VocabCache<T> vocabCache;
    private WeightLookupTable<T> lookupTable;
    private VectorsConfiguration configuration;
    protected static double MAX_EXP = 6.0;
    protected int window;
    protected boolean useAdaGrad;
    protected double negative;
    protected double sampling;
    protected double[] expTable;
    protected INDArray syn0;
    protected INDArray syn1;
    protected INDArray syn1Neg;
    protected INDArray table;
    private CBOW<T> cbow = new CBOW();

    @Override
    public ElementsLearningAlgorithm<T> getElementsLearningAlgorithm() {
        return this.cbow;
    }

    @Override
    public String getCodeName() {
        return "PV-DM";
    }

    @Override
    public void configure(@NonNull VocabCache<T> vocabCache, @NonNull WeightLookupTable<T> lookupTable, @NonNull VectorsConfiguration configuration) {
        if (vocabCache == null) {
            throw new NullPointerException("vocabCache");
        }
        if (lookupTable == null) {
            throw new NullPointerException("lookupTable");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration");
        }
        this.vocabCache = vocabCache;
        this.lookupTable = lookupTable;
        this.configuration = configuration;
        this.cbow.configure(vocabCache, lookupTable, configuration);
        this.window = configuration.getWindow();
        this.useAdaGrad = configuration.isUseAdaGrad();
        this.negative = configuration.getNegative();
        this.sampling = configuration.getSampling();
        this.syn0 = ((InMemoryLookupTable)lookupTable).getSyn0();
        this.syn1 = ((InMemoryLookupTable)lookupTable).getSyn1();
        this.syn1Neg = ((InMemoryLookupTable)lookupTable).getSyn1Neg();
        this.expTable = ((InMemoryLookupTable)lookupTable).getExpTable();
        this.table = ((InMemoryLookupTable)lookupTable).getTable();
    }

    @Override
    public void pretrain(SequenceIterator<T> iterator) {
    }

    @Override
    public double learnSequence(Sequence<T> sequence, AtomicLong nextRandom, double learningRate) {
        Sequence<T> seq = this.cbow.applySubsampling(sequence, nextRandom);
        ArrayList<T> labels = new ArrayList<T>();
        labels.addAll(sequence.getSequenceLabels());
        if (sequence.getSequenceLabel() == null) {
            throw new IllegalStateException("Label is NULL");
        }
        if (seq.isEmpty() || labels.isEmpty()) {
            return 0.0;
        }
        for (int i = 0; i < seq.size(); ++i) {
            nextRandom.set(Math.abs(nextRandom.get() * 25214903917L + 11L));
            this.dm(i, seq, (int)nextRandom.get() % this.window, nextRandom, learningRate, labels, false, null);
        }
        return 0.0;
    }

    public void dm(int i, Sequence<T> sequence, int b, AtomicLong nextRandom, double alpha, List<T> labels, boolean isInference, INDArray inferenceVector) {
        int end = this.window * 2 + 1 - b;
        T currentWord = sequence.getElementByIndex(i);
        ArrayList<Integer> intsList = new ArrayList<Integer>();
        for (int a = b; a < end; ++a) {
            int c;
            if (a == this.window || (c = i - this.window + a) < 0 || c >= sequence.size()) continue;
            T lastWord = sequence.getElementByIndex(c);
            intsList.add(((SequenceElement)lastWord).getIndex());
        }
        if (labels != null) {
            for (SequenceElement label : labels) {
                intsList.add(label.getIndex());
            }
        }
        int[] windowWords = new int[intsList.size()];
        for (int x = 0; x < windowWords.length; ++x) {
            windowWords[x] = (Integer)intsList.get(x);
        }
        this.cbow.iterateSample(currentWord, windowWords, nextRandom, alpha, isInference, labels == null ? 0 : labels.size(), this.configuration.isTrainElementsVectors(), inferenceVector);
        if (this.cbow.getBatch().size() >= this.configuration.getBatchSize()) {
            Nd4j.getExecutioner().exec(this.cbow.getBatch());
            this.cbow.getBatch().clear();
        }
    }

    @Override
    public boolean isEarlyTerminationHit() {
        return false;
    }

    @Override
    public INDArray inferSequence(Sequence<T> sequence, long nr, double learningRate, double minLearningRate, int iterations) {
        AtomicLong nextRandom = new AtomicLong(nr);
        if (sequence.isEmpty()) {
            return null;
        }
        Random random = Nd4j.getRandomFactory().getNewRandomInstance(this.configuration.getSeed() * (long)sequence.hashCode(), (long)(this.lookupTable.layerSize() + 1));
        INDArray ret = Nd4j.rand((int[])new int[]{1, this.lookupTable.layerSize()}, (Random)random).subi((Number)0.5).divi((Number)this.lookupTable.layerSize());
        for (int iter = 0; iter < iterations; ++iter) {
            for (int i = 0; i < sequence.size(); ++i) {
                nextRandom.set(Math.abs(nextRandom.get() * 25214903917L + 11L));
                this.dm(i, sequence, (int)nextRandom.get() % this.window, nextRandom, learningRate, null, true, ret);
            }
            learningRate = (learningRate - minLearningRate) / (double)(iterations - iter) + minLearningRate;
        }
        return ret;
    }

    @Override
    public void finish() {
        if (this.cbow != null && this.cbow.getBatch() != null && this.cbow.getBatch().size() >= this.configuration.getBatchSize()) {
            Nd4j.getExecutioner().exec(this.cbow.getBatch());
            this.cbow.getBatch().clear();
        }
    }
}

