/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.sentenceiterator;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Bits;
import org.deeplearning4j.berkeley.StringUtils;
import org.deeplearning4j.text.sentenceiterator.SentenceIterator;
import org.deeplearning4j.text.sentenceiterator.SentencePreProcessor;

public class LuceneSentenceIterator
implements SentenceIterator {
    private Directory dir;
    private transient IndexReader reader;
    public static final String WORD_FIELD = "word";
    private int index = 0;
    private SentencePreProcessor preProcessor;
    private List<Integer> docs;

    public LuceneSentenceIterator(Directory dir) {
        try {
            this.dir = dir;
            this.reader = DirectoryReader.open((Directory)dir);
            this.docs = this.allDocs();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String nextSentence() {
        Document doc = null;
        try {
            doc = this.reader.document(this.docs.get(this.index).intValue());
            ++this.index;
            Object[] values = doc.getValues(WORD_FIELD);
            return StringUtils.join((Object[])values, (String)" ");
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.index < this.docs.size();
    }

    @Override
    public void reset() {
        this.index = 0;
    }

    @Override
    public void finish() {
        IOUtils.closeQuietly((Closeable)this.reader);
    }

    @Override
    public SentencePreProcessor getPreProcessor() {
        return this.preProcessor;
    }

    @Override
    public void setPreProcessor(SentencePreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    private List<Integer> allDocs() {
        ArrayList<Integer> docIds = new ArrayList<Integer>();
        Bits liveDocs = MultiFields.getLiveDocs((IndexReader)this.reader);
        for (int i = 0; i < this.reader.maxDoc() + 1; ++i) {
            if (liveDocs != null && !liveDocs.get(i)) continue;
            docIds.add(i);
        }
        return docIds;
    }
}

