/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.sequencevectors.sequence;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;

public class Sequence<T extends SequenceElement>
implements Serializable {
    private static final long serialVersionUID = 2223750736522624731L;
    protected List<T> elements = new ArrayList<T>();
    protected T label;
    protected int sequenceId;

    public Sequence() {
    }

    public Sequence(@NonNull Collection<T> set) {
        this();
        if (set == null) {
            throw new NullPointerException("set");
        }
        this.addElements(set);
    }

    public void addElement(@NonNull T element) {
        if (element == null) {
            throw new NullPointerException("element");
        }
        this.elements.add(element);
    }

    public void addElements(Collection<T> set) {
        for (SequenceElement element : set) {
            this.addElement(element);
        }
    }

    public List<String> asLabels() {
        ArrayList<String> labels = new ArrayList<String>();
        for (SequenceElement element : this.getElements()) {
            labels.add(element.getLabel());
        }
        return labels;
    }

    public T getElementByLabel(@NonNull String label) {
        if (label == null) {
            throw new NullPointerException("label");
        }
        for (SequenceElement element : this.elements) {
            if (!element.getLabel().equals(label)) continue;
            return (T)element;
        }
        return null;
    }

    public List<T> getElements() {
        return Collections.unmodifiableList(this.elements);
    }

    public T getSequenceLabel() {
        return this.label;
    }

    public void setSequenceLabel(@NonNull T label) {
        if (label == null) {
            throw new NullPointerException("label");
        }
        this.label = label;
    }

    public String toString() {
        return "Sequence{ label=" + this.label + ", elements=" + this.elements + '}';
    }

    public int getSequenceId() {
        return this.sequenceId;
    }

    public void setSequenceId(int sequenceId) {
        this.sequenceId = sequenceId;
    }
}

