/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.glove.actor;

import akka.actor.UntypedActor;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.deeplearning4j.berkeley.Counter;
import org.deeplearning4j.berkeley.CounterMap;
import org.deeplearning4j.models.glove.actor.SentenceWork;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.deeplearning4j.text.tokenization.tokenizerfactory.TokenizerFactory;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoOccurrenceActor
extends UntypedActor {
    private TokenizerFactory tokenizerFactory;
    private int windowSize = 5;
    private VocabCache<? extends SequenceElement> cache;
    private CounterMap<String, String> coOCurreneCounts = new CounterMap();
    private Counter<Integer> occurrenceAllocations;
    private AtomicInteger processed;
    private boolean symmetric = true;
    private static final Logger log = LoggerFactory.getLogger(CoOccurrenceActor.class);

    public CoOccurrenceActor(AtomicInteger processed, TokenizerFactory tokenizerFactory, int windowSize, VocabCache cache, CounterMap<String, String> coOCurreneCounts, boolean symmetric, Counter<Integer> occurrenceAllocations) {
        this.processed = processed;
        this.tokenizerFactory = tokenizerFactory;
        this.windowSize = windowSize;
        this.cache = cache;
        this.coOCurreneCounts = coOCurreneCounts;
        this.symmetric = symmetric;
        this.occurrenceAllocations = occurrenceAllocations;
    }

    public void onReceive(Object message) throws Exception {
        if (message instanceof SentenceWork) {
            SentenceWork work = (SentenceWork)message;
            String s = work.getSentence();
            List<String> tokens = this.tokenizerFactory.create(s).getTokens();
            for (int i = 0; i < tokens.size(); ++i) {
                String w1;
                int wordIdx = this.cache.indexOf(tokens.get(i));
                if (wordIdx < 0 || (w1 = this.cache.wordFor(tokens.get(i)).getLabel()).equals("UNK")) continue;
                int windowStop = Math.min(i + this.windowSize + 1, tokens.size());
                for (int j = i; j < windowStop; ++j) {
                    String w2;
                    int otherWord = this.cache.indexOf(tokens.get(j));
                    if (otherWord < 0 || (w2 = this.cache.wordFor(tokens.get(j)).getLabel()).equals("UNK") || otherWord == wordIdx) continue;
                    if (wordIdx < otherWord) {
                        this.coOCurreneCounts.incrementCount((Object)tokens.get(i), (Object)tokens.get(j), 1.0 / ((double)(j - i) + Nd4j.EPS_THRESHOLD));
                        this.occurrenceAllocations.incrementCount((Object)work.getId(), 1.0);
                        if (!this.symmetric) continue;
                        this.coOCurreneCounts.incrementCount((Object)tokens.get(j), (Object)tokens.get(i), 1.0 / ((double)(j - i) + Nd4j.EPS_THRESHOLD));
                        this.occurrenceAllocations.incrementCount((Object)work.getId(), 1.0);
                        continue;
                    }
                    this.coOCurreneCounts.incrementCount((Object)tokens.get(j), (Object)tokens.get(i), 1.0 / ((double)(j - i) + Nd4j.EPS_THRESHOLD));
                    this.occurrenceAllocations.incrementCount((Object)work.getId(), 1.0);
                    if (!this.symmetric) continue;
                    this.coOCurreneCounts.incrementCount((Object)tokens.get(i), (Object)tokens.get(j), 1.0 / ((double)(j - i) + Nd4j.EPS_THRESHOLD));
                    this.occurrenceAllocations.incrementCount((Object)work.getId(), 1.0);
                }
            }
            this.processed.incrementAndGet();
        } else {
            this.unhandled(message);
        }
    }
}

