/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.invertedindex;

import com.google.common.base.Function;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.ReaderManager;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TrackingIndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.apache.lucene.util.Bits;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.deeplearning4j.text.invertedindex.InvertedIndex;
import org.deeplearning4j.text.stopwords.StopWords;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneInvertedIndex
implements InvertedIndex,
IndexReader.ReaderClosedListener,
Iterator<List<VocabWord>> {
    private transient Directory dir;
    private transient IndexReader reader;
    private transient Analyzer analyzer;
    private VocabCache vocabCache;
    public static final String WORD_FIELD = "word";
    public static final String LABEL = "label";
    private int numDocs = 0;
    private AtomicBoolean indexBeingCreated = new AtomicBoolean(false);
    private static final Logger log = LoggerFactory.getLogger(LuceneInvertedIndex.class);
    public static final String INDEX_PATH = "word2vec-index";
    private AtomicBoolean readerClosed = new AtomicBoolean(false);
    private AtomicInteger totalWords = new AtomicInteger(0);
    private int batchSize = 1000;
    private List<List<VocabWord>> miniBatches = new CopyOnWriteArrayList<List<VocabWord>>();
    private List<VocabWord> currMiniBatch = Collections.synchronizedList(new ArrayList());
    private double sample = 0.0;
    private AtomicLong nextRandom = new AtomicLong(5L);
    private String indexPath = "word2vec-index";
    private Queue<List<VocabWord>> miniBatchDocs = new ConcurrentLinkedDeque<List<VocabWord>>();
    private AtomicBoolean miniBatchGoing = new AtomicBoolean(true);
    private boolean miniBatch = false;
    public static final String DEFAULT_INDEX_DIR = "word2vec-index";
    private transient SearcherManager searcherManager;
    private transient ReaderManager readerManager;
    private transient TrackingIndexWriter indexWriter;
    private transient LockFactory lockFactory;

    public LuceneInvertedIndex(VocabCache vocabCache, boolean cache) {
        this(vocabCache, cache, "word2vec-index");
    }

    public LuceneInvertedIndex(VocabCache vocabCache, boolean cache, String indexPath) {
        this.vocabCache = vocabCache;
        this.indexPath = indexPath;
        if (new File(indexPath).exists()) {
            indexPath = UUID.randomUUID().toString();
            log.warn("Changing index path to" + indexPath);
        }
        this.initReader();
    }

    public LuceneInvertedIndex(VocabCache vocabCache) {
        this(vocabCache, false, "word2vec-index");
    }

    @Override
    public Iterator<List<List<VocabWord>>> batchIter(int batchSize) {
        return new BatchDocIter(batchSize);
    }

    @Override
    public Iterator<List<VocabWord>> docs() {
        return new DocIter();
    }

    @Override
    public void unlock() {
        if (this.lockFactory == null) {
            this.lockFactory = NativeFSLockFactory.getDefault();
        }
    }

    @Override
    public void cleanup() {
        try {
            this.indexWriter.deleteAll();
            this.indexWriter.getIndexWriter().commit();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public double sample() {
        return this.sample;
    }

    @Override
    public Iterator<List<VocabWord>> miniBatches() {
        return this;
    }

    @Override
    public synchronized List<VocabWord> document(int index) {
        CopyOnWriteArrayList<VocabWord> ret = new CopyOnWriteArrayList<VocabWord>();
        try {
            String[] values;
            DirectoryReader reader = (DirectoryReader)this.readerManager.acquire();
            Document doc = reader.document(index);
            reader.close();
            for (String s : values = doc.getValues(WORD_FIELD)) {
                VocabWord word = this.vocabCache.wordFor(s);
                if (word == null) continue;
                ret.add(this.vocabCache.wordFor(s));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Override
    public int[] documents(VocabWord vocabWord) {
        try {
            TermQuery query = new TermQuery(new Term(WORD_FIELD, vocabWord.getWord().toLowerCase()));
            this.searcherManager.maybeRefresh();
            IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
            TopDocs topdocs = searcher.search((Query)query, Integer.MAX_VALUE);
            int[] ret = new int[topdocs.totalHits];
            for (int i = 0; i < topdocs.totalHits; ++i) {
                ret[i] = topdocs.scoreDocs[i].doc;
            }
            this.searcherManager.release((Object)searcher);
            return ret;
        }
        catch (AlreadyClosedException e) {
            return this.documents(vocabWord);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int numDocuments() {
        try {
            this.readerManager.maybeRefresh();
            DirectoryReader reader = (DirectoryReader)this.readerManager.acquire();
            int ret = reader.numDocs();
            this.readerManager.release((Object)reader);
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int[] allDocs() {
        DirectoryReader reader;
        try {
            this.readerManager.maybeRefreshBlocking();
            reader = (DirectoryReader)this.readerManager.acquire();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        int[] docIds = new int[reader.maxDoc()];
        if (docIds.length < 1) {
            throw new IllegalStateException("No documents found");
        }
        int count = 0;
        Bits liveDocs = MultiFields.getLiveDocs((IndexReader)reader);
        for (int i = 0; i < reader.maxDoc(); ++i) {
            if (liveDocs != null && !liveDocs.get(i)) continue;
            if (count > docIds.length) {
                int[] newCopy = new int[docIds.length * 2];
                System.arraycopy(docIds, 0, newCopy, 0, docIds.length);
                docIds = newCopy;
                log.info("Reallocating doc ids");
            }
            docIds[count++] = i;
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return docIds;
    }

    @Override
    public void addWordToDoc(int doc, VocabWord word) {
        TextField f = new TextField(WORD_FIELD, word.getWord(), Field.Store.YES);
        try {
            IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
            Document doc2 = searcher.doc(doc);
            if (doc2 != null) {
                doc2.add((IndexableField)f);
            } else {
                Document d = new Document();
                d.add((IndexableField)f);
            }
            this.searcherManager.release((Object)searcher);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initReader() {
        if (this.reader == null) {
            try {
                IndexWriter writer;
                this.ensureDirExists();
                if (this.getWriter() == null) {
                    this.indexWriter = null;
                    while (this.getWriter() == null) {
                        log.warn("Writer was null...reinitializing");
                        Thread.sleep(1000L);
                    }
                }
                if ((writer = this.getWriter().getIndexWriter()) == null) {
                    throw new IllegalStateException("index writer was null");
                }
                this.searcherManager = new SearcherManager(writer, true, new SearcherFactory());
                writer.commit();
                this.readerManager = new ReaderManager(this.dir);
                DirectoryReader reader = (DirectoryReader)this.readerManager.acquire();
                this.numDocs = ((DirectoryReader)this.readerManager.acquire()).numDocs();
                this.readerManager.release((Object)reader);
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void addWordsToDoc(int doc, List<VocabWord> words) {
        Document d = new Document();
        for (VocabWord word : words) {
            d.add((IndexableField)new TextField(WORD_FIELD, word.getWord(), Field.Store.YES));
        }
        this.totalWords.set(this.totalWords.get() + words.size());
        this.addWords(words);
        try {
            this.getWriter().addDocument((Iterable)d);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Pair<List<VocabWord>, String> documentWithLabel(int index) {
        CopyOnWriteArrayList<VocabWord> ret = new CopyOnWriteArrayList<VocabWord>();
        String label = "NONE";
        try {
            DirectoryReader reader = (DirectoryReader)this.readerManager.acquire();
            Document doc = reader.document(index);
            reader.close();
            String[] values = doc.getValues(WORD_FIELD);
            label = doc.get(LABEL);
            if (label == null) {
                label = "NONE";
            }
            for (String s : values) {
                ret.add(this.vocabCache.wordFor(s));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new Pair(ret, (Object)label);
    }

    @Override
    public Pair<List<VocabWord>, Collection<String>> documentWithLabels(int index) {
        CopyOnWriteArrayList<VocabWord> ret = new CopyOnWriteArrayList<VocabWord>();
        ArrayList labels = new ArrayList();
        try {
            DirectoryReader reader = (DirectoryReader)this.readerManager.acquire();
            Document doc = reader.document(index);
            this.readerManager.release((Object)reader);
            String[] values = doc.getValues(WORD_FIELD);
            String[] labels2 = doc.getValues(LABEL);
            for (String s : values) {
                ret.add(this.vocabCache.wordFor(s));
            }
            Collections.addAll(labels, labels2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new Pair(ret, labels);
    }

    @Override
    public void addLabelForDoc(int doc, VocabWord word) {
        this.addLabelForDoc(doc, word.getWord());
    }

    @Override
    public void addLabelForDoc(int doc, String label) {
        try {
            DirectoryReader reader = (DirectoryReader)this.readerManager.acquire();
            Document doc2 = reader.document(doc);
            doc2.add((IndexableField)new TextField(LABEL, label, Field.Store.YES));
            this.readerManager.release((Object)reader);
            TrackingIndexWriter writer = this.getWriter();
            Term term = new Term(LABEL, label);
            writer.updateDocument(term, (Iterable)doc2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addWordsToDoc(int doc, List<VocabWord> words, String label) {
        Document d = new Document();
        for (VocabWord word : words) {
            d.add((IndexableField)new TextField(WORD_FIELD, word.getWord(), Field.Store.YES));
        }
        d.add((IndexableField)new TextField(LABEL, label, Field.Store.YES));
        this.totalWords.set(this.totalWords.get() + words.size());
        this.addWords(words);
        try {
            this.getWriter().addDocument((Iterable)d);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addWordsToDoc(int doc, List<VocabWord> words, VocabWord label) {
        this.addWordsToDoc(doc, words, label.getWord());
    }

    @Override
    public void addLabelsForDoc(int doc, List<VocabWord> label) {
        try {
            DirectoryReader reader = (DirectoryReader)this.readerManager.acquire();
            Document doc2 = reader.document(doc);
            for (VocabWord s : label) {
                doc2.add((IndexableField)new TextField(LABEL, s.getWord(), Field.Store.YES));
            }
            this.readerManager.release((Object)reader);
            TrackingIndexWriter writer = this.getWriter();
            ArrayList<Term> terms = new ArrayList<Term>();
            for (VocabWord s : label) {
                Term term = new Term(LABEL, s.getWord());
                terms.add(term);
            }
            writer.addDocument((Iterable)doc2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addLabelsForDoc(int doc, Collection<String> label) {
        try {
            DirectoryReader reader = (DirectoryReader)this.readerManager.acquire();
            Document doc2 = reader.document(doc);
            for (String s : label) {
                doc2.add((IndexableField)new TextField(LABEL, s, Field.Store.YES));
            }
            this.readerManager.release((Object)reader);
            TrackingIndexWriter writer = this.getWriter();
            ArrayList<Term> terms = new ArrayList<Term>();
            for (String s : label) {
                Term term = new Term(LABEL, s);
                terms.add(term);
            }
            writer.addDocument((Iterable)doc2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addWordsToDoc(int doc, List<VocabWord> words, Collection<String> label) {
        Document d = new Document();
        for (VocabWord word : words) {
            d.add((IndexableField)new TextField(WORD_FIELD, word.getWord(), Field.Store.YES));
        }
        for (String s : label) {
            d.add((IndexableField)new TextField(LABEL, s, Field.Store.YES));
        }
        this.totalWords.set(this.totalWords.get() + words.size());
        this.addWords(words);
        try {
            this.getWriter().addDocument((Iterable)d);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addWordsToDocVocabWord(int doc, List<VocabWord> words, Collection<VocabWord> label) {
        Document d = new Document();
        for (VocabWord word : words) {
            d.add((IndexableField)new TextField(WORD_FIELD, word.getWord(), Field.Store.YES));
        }
        for (VocabWord s : label) {
            d.add((IndexableField)new TextField(LABEL, s.getWord(), Field.Store.YES));
        }
        this.totalWords.set(this.totalWords.get() + words.size());
        this.addWords(words);
        try {
            this.getWriter().addDocument((Iterable)d);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addWords(List<VocabWord> words) {
        if (!this.miniBatch) {
            return;
        }
        for (VocabWord word : words) {
            if (this.sample > 0.0) {
                double ran = (Math.sqrt(word.getWordFrequency() / (this.sample * (double)this.numDocuments())) + 1.0) * (this.sample * (double)this.numDocuments()) / word.getWordFrequency();
                if (ran < (double)(this.nextRandom.get() & 0xFFFFL) / 65536.0) continue;
                this.currMiniBatch.add(word);
                continue;
            }
            this.currMiniBatch.add(word);
            if (this.currMiniBatch.size() < this.batchSize) continue;
            this.miniBatches.add(new ArrayList<VocabWord>(this.currMiniBatch));
            this.currMiniBatch.clear();
        }
    }

    private void ensureDirExists() throws IOException {
        if (this.dir == null) {
            File directory = new File(this.indexPath);
            log.info("Creating directory " + directory.getCanonicalPath());
            FileUtils.deleteDirectory((File)directory);
            this.dir = FSDirectory.open((Path)Paths.get(directory.toURI()));
            if (!directory.exists()) {
                directory.mkdir();
            }
        }
    }

    private synchronized TrackingIndexWriter getWriterWithRetry() {
        if (this.indexWriter != null) {
            return this.indexWriter;
        }
        try {
            if (this.analyzer == null) {
                this.analyzer = new StandardAnalyzer((Reader)new InputStreamReader(new ByteArrayInputStream("".getBytes())));
            }
            this.ensureDirExists();
            if (this.indexWriter == null) {
                IndexWriter writer;
                this.indexBeingCreated.set(true);
                IndexWriterConfig iwc = new IndexWriterConfig(this.analyzer);
                iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
                iwc.setWriteLockTimeout(1000L);
                log.info("Creating new index writer");
                while ((writer = this.tryCreateWriter(iwc)) == null) {
                    log.warn("Failed to create writer...trying again");
                    iwc = new IndexWriterConfig(this.analyzer);
                    iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
                    iwc.setWriteLockTimeout(1000L);
                    Thread.sleep(10000L);
                }
                this.indexWriter = new TrackingIndexWriter(writer);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return this.indexWriter;
    }

    private IndexWriter tryCreateWriter(IndexWriterConfig iwc) {
        try {
            this.dir.close();
            this.dir = null;
            FileUtils.deleteDirectory((File)new File(this.indexPath));
            this.ensureDirExists();
            if (this.lockFactory == null) {
                this.lockFactory = NativeFSLockFactory.getDefault();
            }
            return new IndexWriter(this.dir, iwc);
        }
        catch (Exception e) {
            String id;
            this.indexPath = id = UUID.randomUUID().toString();
            log.warn("Setting index path to " + id);
            log.warn("Couldn't create index ", (Throwable)e);
            return null;
        }
    }

    private synchronized TrackingIndexWriter getWriter() {
        for (int attempts = 0; this.getWriterWithRetry() == null && attempts < 3; ++attempts) {
            try {
                Thread.sleep(1000 * attempts);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (attempts < 3) continue;
            throw new IllegalStateException("Can't obtain write lock");
        }
        return this.indexWriter;
    }

    @Override
    public void finish() {
        try {
            this.initReader();
            DirectoryReader reader = (DirectoryReader)this.readerManager.acquire();
            this.numDocs = reader.numDocs();
            this.readerManager.release((Object)reader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long totalWords() {
        return this.totalWords.get();
    }

    @Override
    public int batchSize() {
        return this.batchSize;
    }

    @Override
    public void eachDocWithLabels(final Function<Pair<List<VocabWord>, Collection<String>>, Void> func, ExecutorService exec) {
        int[] docIds;
        int[] nArray = docIds = this.allDocs();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int i2;
            final int j = i2 = nArray[i];
            exec.execute(new Runnable(){

                @Override
                public void run() {
                    func.apply(LuceneInvertedIndex.this.documentWithLabels(j));
                }
            });
        }
    }

    @Override
    public void eachDocWithLabel(final Function<Pair<List<VocabWord>, String>, Void> func, ExecutorService exec) {
        int[] docIds;
        int[] nArray = docIds = this.allDocs();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int i2;
            final int j = i2 = nArray[i];
            exec.execute(new Runnable(){

                @Override
                public void run() {
                    func.apply(LuceneInvertedIndex.this.documentWithLabel(j));
                }
            });
        }
    }

    @Override
    public void eachDoc(final Function<List<VocabWord>, Void> func, ExecutorService exec) {
        int[] docIds;
        int[] nArray = docIds = this.allDocs();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int i2;
            final int j = i2 = nArray[i];
            exec.execute(new Runnable(){

                @Override
                public void run() {
                    func.apply(LuceneInvertedIndex.this.document(j));
                }
            });
        }
    }

    public void onClose(IndexReader reader) {
        this.readerClosed.set(true);
    }

    @Override
    public boolean hasNext() {
        if (!this.miniBatch) {
            throw new IllegalStateException("Mini batch mode turned off");
        }
        return !this.miniBatchDocs.isEmpty() || this.miniBatchGoing.get();
    }

    @Override
    public List<VocabWord> next() {
        if (!this.miniBatch) {
            throw new IllegalStateException("Mini batch mode turned off");
        }
        if (!this.miniBatches.isEmpty()) {
            return this.miniBatches.remove(0);
        }
        if (this.miniBatchGoing.get()) {
            while (this.miniBatches.isEmpty()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                log.warn("Waiting on more data...");
                if (this.miniBatches.isEmpty()) continue;
                return this.miniBatches.remove(0);
            }
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static class Builder {
        private File indexDir;
        private Directory dir;
        private IndexReader reader;
        private Analyzer analyzer;
        private IndexSearcher searcher;
        private IndexWriter writer;
        private IndexWriterConfig iwc;
        private VocabCache vocabCache;
        private List<String> stopWords;
        private boolean cache;
        private int batchSize;
        private double sample;
        private boolean miniBatch;

        public Builder() {
            this.iwc = new IndexWriterConfig(this.analyzer);
            this.stopWords = StopWords.getStopWords();
            this.cache = false;
            this.batchSize = 1000;
            this.sample = 0.0;
            this.miniBatch = false;
        }

        public Builder miniBatch(boolean miniBatch) {
            this.miniBatch = miniBatch;
            return this;
        }

        public Builder cacheInRam(boolean cache) {
            this.cache = cache;
            return this;
        }

        public Builder sample(double sample) {
            this.sample = sample;
            return this;
        }

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder indexDir(File indexDir) {
            this.indexDir = indexDir;
            return this;
        }

        public Builder cache(VocabCache cache) {
            this.vocabCache = cache;
            return this;
        }

        public Builder stopWords(List<String> stopWords) {
            this.stopWords = stopWords;
            return this;
        }

        public Builder dir(Directory dir) {
            this.dir = dir;
            return this;
        }

        public Builder reader(IndexReader reader) {
            this.reader = reader;
            return this;
        }

        public Builder writer(IndexWriter writer) {
            this.writer = writer;
            return this;
        }

        public Builder analyzer(Analyzer analyzer) {
            this.analyzer = analyzer;
            return this;
        }

        public InvertedIndex build() {
            LuceneInvertedIndex ret = this.indexDir != null ? new LuceneInvertedIndex(this.vocabCache, this.cache, this.indexDir.getAbsolutePath()) : new LuceneInvertedIndex(this.vocabCache);
            try {
                ret.batchSize = this.batchSize;
                if (this.dir != null) {
                    ret.dir = this.dir;
                }
                ret.miniBatch = this.miniBatch;
                if (this.reader != null) {
                    ret.reader = this.reader;
                }
                if (this.analyzer != null) {
                    ret.analyzer = this.analyzer;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }
    }

    public class DocIter
    implements Iterator<List<VocabWord>> {
        private int currIndex = 0;
        private int[] docs = LuceneInvertedIndex.this.allDocs();

        @Override
        public boolean hasNext() {
            return this.currIndex < this.docs.length;
        }

        @Override
        public List<VocabWord> next() {
            return LuceneInvertedIndex.this.document(this.docs[this.currIndex++]);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class BatchDocIter
    implements Iterator<List<List<VocabWord>>> {
        private int batchSize = 1000;
        private Iterator<List<VocabWord>> docIter = new DocIter();

        public BatchDocIter(int batchSize) {
            this.batchSize = batchSize;
        }

        @Override
        public boolean hasNext() {
            return this.docIter.hasNext();
        }

        @Override
        public List<List<VocabWord>> next() {
            ArrayList<List<VocabWord>> ret = new ArrayList<List<VocabWord>>();
            for (int i = 0; i < this.batchSize && this.docIter.hasNext(); ++i) {
                ret.add(this.docIter.next());
            }
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

