/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.word2vec.wordstore.inmemory;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.deeplearning4j.berkeley.Counter;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.deeplearning4j.text.movingwindow.Util;
import org.deeplearning4j.util.Index;
import org.deeplearning4j.util.SerializationUtils;

public class InMemoryLookupCache
implements VocabCache,
Serializable {
    private Index wordIndex = new Index();
    public Counter<String> wordFrequencies = Util.parallelCounter();
    public Counter<String> docFrequencies = Util.parallelCounter();
    public Map<String, VocabWord> vocabs = new ConcurrentHashMap<String, VocabWord>();
    public Map<String, VocabWord> tokens = new ConcurrentHashMap<String, VocabWord>();
    private AtomicLong totalWordOccurrences = new AtomicLong(0L);
    private int numDocs = 0;

    public synchronized void setWordFrequencies(Counter<String> cnt) {
        this.wordFrequencies = cnt;
    }

    public synchronized Map<String, VocabWord> getVocabs() {
        return this.vocabs;
    }

    public synchronized void setVocabs(Map<String, VocabWord> vocabs) {
        this.vocabs = vocabs;
    }

    public synchronized Counter<String> getWordFrequencies() {
        return this.wordFrequencies;
    }

    public synchronized void setTokens(Map<String, VocabWord> tokens) {
        this.tokens = tokens;
    }

    public synchronized Map<String, VocabWord> getTokens() {
        return this.tokens;
    }

    public InMemoryLookupCache() {
        this(false);
    }

    public InMemoryLookupCache(boolean addUnk) {
        if (addUnk) {
            VocabWord word = new VocabWord(1.0, "UNK");
            word.setIndex(0);
            this.addToken(word);
            this.addWordToIndex(0, "UNK");
            this.putVocabWord("UNK");
        }
    }

    @Override
    public synchronized Collection<String> words() {
        return this.vocabs.keySet();
    }

    @Override
    public synchronized void incrementWordCount(String word) {
        this.incrementWordCount(word, 1);
    }

    @Override
    public synchronized void incrementWordCount(String word, int increment) {
        if (word == null || word.isEmpty()) {
            throw new IllegalArgumentException("Word can't be empty or null");
        }
        this.wordFrequencies.incrementCount((Object)word, (double)increment);
        if (this.hasToken(word)) {
            VocabWord token = this.tokenFor(word);
            token.increment(increment);
        }
        this.totalWordOccurrences.set(this.totalWordOccurrences.get() + (long)increment);
    }

    @Override
    public synchronized int wordFrequency(String word) {
        return (int)this.wordFrequencies.getCount((Object)word);
    }

    @Override
    public synchronized boolean containsWord(String word) {
        return this.vocabs.containsKey(word);
    }

    @Override
    public synchronized String wordAtIndex(int index) {
        return (String)this.wordIndex.get(index);
    }

    @Override
    public synchronized int indexOf(String word) {
        return this.wordIndex.indexOf((Object)word);
    }

    @Override
    public synchronized Collection<VocabWord> vocabWords() {
        return this.vocabs.values();
    }

    @Override
    public synchronized long totalWordOccurrences() {
        return this.totalWordOccurrences.get();
    }

    @Override
    public synchronized VocabWord wordFor(String word) {
        if (word == null) {
            return null;
        }
        VocabWord ret = this.vocabs.get(word);
        return ret;
    }

    @Override
    public synchronized void addWordToIndex(int index, String word) {
        if (word == null || word.isEmpty()) {
            throw new IllegalArgumentException("Word can't be empty or null");
        }
        if (!this.wordFrequencies.containsKey((Object)word)) {
            this.wordFrequencies.incrementCount((Object)word, 1.0);
        }
        this.wordIndex.add((Object)word, index);
    }

    @Override
    public synchronized void putVocabWord(String word) {
        if (word == null || word.isEmpty()) {
            throw new IllegalArgumentException("Word can't be empty or null");
        }
        if (word.equals("STOP") || word.equals("UNK")) {
            return;
        }
        VocabWord token = this.tokenFor(word);
        if (token == null) {
            throw new IllegalStateException("Word " + word + " not found as token in vocab");
        }
        int ind = token.getIndex();
        this.addWordToIndex(ind, word);
        if (!this.hasToken(word)) {
            throw new IllegalStateException("Unable to add token " + word + " when not already a token");
        }
        this.vocabs.put(word, token);
        this.wordIndex.add((Object)word, token.getIndex());
    }

    @Override
    public synchronized int numWords() {
        return this.vocabs.size();
    }

    @Override
    public synchronized int docAppearedIn(String word) {
        return (int)this.docFrequencies.getCount((Object)word);
    }

    @Override
    public synchronized void incrementDocCount(String word, int howMuch) {
        this.docFrequencies.incrementCount((Object)word, (double)howMuch);
    }

    @Override
    public synchronized void setCountForDoc(String word, int count) {
        this.docFrequencies.setCount((Object)word, (double)count);
    }

    @Override
    public synchronized int totalNumberOfDocs() {
        return this.numDocs;
    }

    @Override
    public synchronized void incrementTotalDocCount() {
        ++this.numDocs;
    }

    @Override
    public synchronized void incrementTotalDocCount(int by) {
        this.numDocs += by;
    }

    @Override
    public synchronized Collection<VocabWord> tokens() {
        return this.tokens.values();
    }

    @Override
    public synchronized void addToken(VocabWord word) {
        this.tokens.put(word.getWord(), word);
    }

    @Override
    public synchronized VocabWord tokenFor(String word) {
        return this.tokens.get(word);
    }

    @Override
    public synchronized boolean hasToken(String token) {
        return this.tokenFor(token) != null;
    }

    @Override
    public synchronized void saveVocab() {
        SerializationUtils.saveObject((Object)this, (File)new File("ser"));
    }

    @Override
    public synchronized boolean vocabExists() {
        return new File("ser").exists();
    }

    public static InMemoryLookupCache load(InputStream from) {
        InputStreamReader inputStream = new InputStreamReader(from);
        LineIterator iter = IOUtils.lineIterator((Reader)inputStream);
        InMemoryLookupCache ret = new InMemoryLookupCache();
        int count = 0;
        while (iter.hasNext()) {
            String line = iter.nextLine();
            if (line.isEmpty()) continue;
            ret.incrementWordCount(line);
            VocabWord word = new VocabWord(1.0, line);
            word.setIndex(count);
            ret.addToken(word);
            ret.addWordToIndex(count, line);
            ret.putVocabWord(line);
            ++count;
        }
        return ret;
    }

    @Override
    public synchronized void loadVocab() {
        InMemoryLookupCache cache = (InMemoryLookupCache)SerializationUtils.readObject((File)new File("ser"));
        this.vocabs = cache.vocabs;
        this.wordFrequencies = cache.wordFrequencies;
        this.wordIndex = cache.wordIndex;
        this.tokens = cache.tokens;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InMemoryLookupCache that = (InMemoryLookupCache)o;
        if (this.numDocs != that.numDocs) {
            return false;
        }
        if (this.wordIndex != null ? !this.wordIndex.equals((Object)that.wordIndex) : that.wordIndex != null) {
            return false;
        }
        if (this.wordFrequencies != null ? !this.wordFrequencies.equals(that.wordFrequencies) : that.wordFrequencies != null) {
            return false;
        }
        if (this.docFrequencies != null ? !this.docFrequencies.equals(that.docFrequencies) : that.docFrequencies != null) {
            return false;
        }
        if (this.vocabWords().equals(that.vocabWords())) {
            return true;
        }
        return true;
    }

    public int hashCode() {
        int result = this.wordIndex != null ? this.wordIndex.hashCode() : 0;
        result = 31 * result + (this.wordFrequencies != null ? this.wordFrequencies.hashCode() : 0);
        result = 31 * result + (this.docFrequencies != null ? this.docFrequencies.hashCode() : 0);
        result = 31 * result + (this.vocabs != null ? this.vocabs.hashCode() : 0);
        result = 31 * result + (this.tokens != null ? this.tokens.hashCode() : 0);
        result = 31 * result + (this.totalWordOccurrences != null ? this.totalWordOccurrences.hashCode() : 0);
        result = 31 * result + this.numDocs;
        return result;
    }

    public String toString() {
        return "InMemoryLookupCache{wordIndex=" + this.wordIndex + ", wordFrequencies=" + this.wordFrequencies + ", docFrequencies=" + this.docFrequencies + ", vocabs=" + this.vocabs + ", tokens=" + this.tokens + ", totalWordOccurrences=" + this.totalWordOccurrences + ", numDocs=" + this.numDocs + '}';
    }
}

