/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.documentiterator;

import java.util.Iterator;
import lombok.NonNull;
import org.deeplearning4j.text.documentiterator.LabelAwareIterator;
import org.deeplearning4j.text.documentiterator.LabelledDocument;
import org.deeplearning4j.text.documentiterator.LabelsSource;

public class SimpleLabelAwareIterator
implements LabelAwareIterator {
    protected transient Iterable<LabelledDocument> underlyingIterable;
    protected transient Iterator<LabelledDocument> currentIterator;
    protected LabelsSource labels = new LabelsSource();

    public SimpleLabelAwareIterator(@NonNull Iterable<LabelledDocument> iterable) {
        if (iterable == null) {
            throw new NullPointerException("iterable");
        }
        this.underlyingIterable = iterable;
        this.currentIterator = this.underlyingIterable.iterator();
    }

    public SimpleLabelAwareIterator(@NonNull Iterator<LabelledDocument> iterator) {
        if (iterator == null) {
            throw new NullPointerException("iterator");
        }
        this.currentIterator = iterator;
    }

    @Override
    public boolean hasNextDocument() {
        return this.currentIterator.hasNext();
    }

    @Override
    public LabelledDocument nextDocument() {
        LabelledDocument document = this.currentIterator.next();
        if (document.getLabel() != null) {
            this.labels.storeLabel(document.getLabel());
        }
        return document;
    }

    @Override
    public void reset() {
        if (this.underlyingIterable == null) {
            throw new UnsupportedOperationException("You can't use reset() method for Iterator<> based instance, please provide Iterable<> instead, or avoid reset()");
        }
        this.currentIterator = this.underlyingIterable.iterator();
    }

    @Override
    public LabelsSource getLabelsSource() {
        return this.labels;
    }
}

