/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.utils;

import java.util.HashMap;
import java.util.Map;
import org.deeplearning4j.nn.api.layers.LayerConstraint;
import org.deeplearning4j.nn.conf.constraint.MaxNormConstraint;
import org.deeplearning4j.nn.conf.constraint.MinMaxNormConstraint;
import org.deeplearning4j.nn.conf.constraint.NonNegativeConstraint;
import org.deeplearning4j.nn.conf.constraint.UnitNormConstraint;
import org.deeplearning4j.nn.modelimport.keras.config.KerasLayerConfiguration;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasLayerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasConstraintUtils {
    private static final Logger log = LoggerFactory.getLogger(KerasConstraintUtils.class);

    public static LayerConstraint mapConstraint(String kerasConstraint, KerasLayerConfiguration conf, Map<String, Object> constraintConfig) throws UnsupportedKerasConfigurationException {
        MaxNormConstraint constraint;
        if (kerasConstraint.equals(conf.getLAYER_FIELD_MINMAX_NORM_CONSTRAINT()) || kerasConstraint.equals(conf.getLAYER_FIELD_MINMAX_NORM_CONSTRAINT_ALIAS())) {
            double min = (Double)constraintConfig.get(conf.getLAYER_FIELD_MINMAX_MIN_CONSTRAINT());
            double max = (Double)constraintConfig.get(conf.getLAYER_FIELD_MINMAX_MAX_CONSTRAINT());
            double rate = (Double)constraintConfig.get(conf.getLAYER_FIELD_CONSTRAINT_RATE());
            int dim = (Integer)constraintConfig.get(conf.getLAYER_FIELD_CONSTRAINT_DIM());
            constraint = new MinMaxNormConstraint(min, max, rate, new int[]{dim + 1});
        } else if (kerasConstraint.equals(conf.getLAYER_FIELD_MAX_NORM_CONSTRAINT()) || kerasConstraint.equals(conf.getLAYER_FIELD_MAX_NORM_CONSTRAINT_ALIAS()) || kerasConstraint.equals(conf.getLAYER_FIELD_MAX_NORM_CONSTRAINT_ALIAS_2())) {
            double max = (Double)constraintConfig.get(conf.getLAYER_FIELD_MAX_CONSTRAINT());
            int dim = (Integer)constraintConfig.get(conf.getLAYER_FIELD_CONSTRAINT_DIM());
            constraint = new MaxNormConstraint(max, new int[]{dim + 1});
        } else if (kerasConstraint.equals(conf.getLAYER_FIELD_UNIT_NORM_CONSTRAINT()) || kerasConstraint.equals(conf.getLAYER_FIELD_UNIT_NORM_CONSTRAINT_ALIAS()) || kerasConstraint.equals(conf.getLAYER_FIELD_UNIT_NORM_CONSTRAINT_ALIAS_2())) {
            int dim = (Integer)constraintConfig.get(conf.getLAYER_FIELD_CONSTRAINT_DIM());
            constraint = new UnitNormConstraint(new int[]{dim + 1});
        } else if (kerasConstraint.equals(conf.getLAYER_FIELD_NON_NEG_CONSTRAINT()) || kerasConstraint.equals(conf.getLAYER_FIELD_NON_NEG_CONSTRAINT_ALIAS()) || kerasConstraint.equals(conf.getLAYER_FIELD_NON_NEG_CONSTRAINT_ALIAS_2())) {
            constraint = new NonNegativeConstraint();
        } else {
            throw new UnsupportedKerasConfigurationException("Unknown keras constraint " + kerasConstraint);
        }
        return constraint;
    }

    public static LayerConstraint getConstraintsFromConfig(Map<String, Object> layerConfig, String constraintField, KerasLayerConfiguration conf, int kerasMajorVersion) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        Map<String, Object> innerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(layerConfig, conf);
        if (!innerConfig.containsKey(constraintField)) {
            return null;
        }
        HashMap constraintMap = (HashMap)innerConfig.get(constraintField);
        if (constraintMap == null) {
            return null;
        }
        if (!constraintMap.containsKey(conf.getLAYER_FIELD_CONSTRAINT_NAME())) {
            throw new InvalidKerasConfigurationException("Keras layer is missing " + conf.getLAYER_FIELD_CONSTRAINT_NAME() + " field");
        }
        String kerasConstraint = (String)constraintMap.get(conf.getLAYER_FIELD_CONSTRAINT_NAME());
        Map<Object, Object> constraintConfig = kerasMajorVersion == 2 ? KerasLayerUtils.getInnerLayerConfigFromConfig(constraintMap, conf) : constraintMap;
        LayerConstraint layerConstraint = KerasConstraintUtils.mapConstraint(kerasConstraint, conf, constraintConfig);
        return layerConstraint;
    }
}

