/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.advanced.activations;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.deeplearning4j.nn.api.layers.LayerConstraint;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.PReLULayer;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasConstraintUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasInitilizationUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasLayerUtils;
import org.deeplearning4j.nn.weights.WeightInit;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.linalg.util.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasPReLU
extends KerasLayer {
    private static final Logger log = LoggerFactory.getLogger(KerasPReLU.class);
    private final String ALPHA = "alpha";
    private final String ALPHA_INIT = "alpha_initializer";
    private final String ALPHA_CONSTRAINT = "alpha_constraint";
    private final String SHARED_AXES = "shared_axes";

    public KerasPReLU(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasPReLU(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        LayerConstraint weightConstraint = KerasConstraintUtils.getConstraintsFromConfig(layerConfig, "alpha_constraint", this.conf, this.kerasMajorVersion);
        Pair<WeightInit, Distribution> init = KerasInitilizationUtils.getWeightInitFromConfig(layerConfig, "alpha_initializer", enforceTrainingConfig, this.conf, this.kerasMajorVersion);
        WeightInit weightInit = (WeightInit)init.getFirst();
        Distribution distribution = (Distribution)init.getSecond();
        long[] axes = this.getSharedAxes(layerConfig);
        PReLULayer.Builder builder = (PReLULayer.Builder)((PReLULayer.Builder)new PReLULayer.Builder().sharedAxes(axes).weightInit(weightInit.getWeightInitFunction(distribution))).name(this.layerName);
        if (weightConstraint != null) {
            builder.constrainWeights(new LayerConstraint[]{weightConstraint});
        }
        this.layer = builder.build();
    }

    private long[] getSharedAxes(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException {
        long[] axes = null;
        Map<String, Object> innerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(layerConfig, this.conf);
        try {
            List axesList = (List)innerConfig.get("shared_axes");
            int[] intAxes = ArrayUtil.toArray((List)axesList);
            axes = new long[intAxes.length];
            for (int i = 0; i < intAxes.length; ++i) {
                axes[i] = intAxes[i];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return axes;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras PReLU layer accepts only one input (received " + inputType.length + ")");
        }
        InputType inType = inputType[0];
        PReLULayer shapedLayer = (PReLULayer)this.layer;
        shapedLayer.setInputShape(inType.getShape());
        this.layer = shapedLayer;
        return this.getPReLULayer().getOutputType(-1, inputType[0]);
    }

    public PReLULayer getPReLULayer() {
        return (PReLULayer)this.layer;
    }

    @Override
    public void setWeights(Map<String, INDArray> weights) throws InvalidKerasConfigurationException {
        this.weights = new HashMap();
        if (!weights.containsKey("alpha")) {
            throw new InvalidKerasConfigurationException("Parameter alpha does not exist in weights");
        }
        this.weights.put("W", weights.get("alpha"));
        if (weights.size() > 1) {
            Set<String> paramNames = weights.keySet();
            paramNames.remove("alpha");
            String unknownParamNames = paramNames.toString();
            log.warn("Attemping to set weights for unknown parameters: " + unknownParamNames.substring(1, unknownParamNames.length() - 1));
        }
    }
}

