/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.recurrent;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.deeplearning4j.nn.api.layers.LayerConstraint;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.recurrent.LastTimeStep;
import org.deeplearning4j.nn.conf.layers.recurrent.SimpleRnn;
import org.deeplearning4j.nn.conf.layers.util.MaskZeroLayer;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.layers.recurrent.KerasRnnUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasActivationUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasConstraintUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasInitilizationUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasLayerUtils;
import org.deeplearning4j.nn.weights.WeightInit;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.primitives.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasSimpleRnn
extends KerasLayer {
    private static final Logger log = LoggerFactory.getLogger(KerasSimpleRnn.class);
    private final int NUM_TRAINABLE_PARAMS = 3;
    protected boolean unroll = false;
    protected boolean returnSequences;

    public KerasSimpleRnn(Integer kerasVersion) throws UnsupportedKerasConfigurationException {
        super(kerasVersion);
    }

    public KerasSimpleRnn(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true, Collections.emptyMap());
    }

    public KerasSimpleRnn(Map<String, Object> layerConfig, Map<String, ? extends KerasLayer> previousLayers) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true, previousLayers);
    }

    public KerasSimpleRnn(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, enforceTrainingConfig, Collections.emptyMap());
    }

    public KerasSimpleRnn(Map<String, Object> layerConfig, boolean enforceTrainingConfig, Map<String, ? extends KerasLayer> previousLayers) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        Pair<WeightInit, Distribution> init = KerasInitilizationUtils.getWeightInitFromConfig(layerConfig, this.conf.getLAYER_FIELD_INIT(), enforceTrainingConfig, this.conf, this.kerasMajorVersion);
        WeightInit weightInit = (WeightInit)init.getFirst();
        Distribution distribution = (Distribution)init.getSecond();
        Pair<WeightInit, Distribution> recurrentInit = KerasInitilizationUtils.getWeightInitFromConfig(layerConfig, this.conf.getLAYER_FIELD_INNER_INIT(), enforceTrainingConfig, this.conf, this.kerasMajorVersion);
        WeightInit recurrentWeightInit = (WeightInit)recurrentInit.getFirst();
        Distribution recurrentDistribution = (Distribution)recurrentInit.getSecond();
        Map<String, Object> innerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(layerConfig, this.conf);
        this.returnSequences = (Boolean)innerConfig.get(this.conf.getLAYER_FIELD_RETURN_SEQUENCES());
        KerasRnnUtils.getRecurrentDropout(this.conf, layerConfig);
        this.unroll = KerasRnnUtils.getUnrollRecurrentLayer(this.conf, layerConfig);
        Pair<Boolean, Double> maskingConfig = KerasLayerUtils.getMaskingConfiguration(this.inboundLayerNames, previousLayers);
        LayerConstraint biasConstraint = KerasConstraintUtils.getConstraintsFromConfig(layerConfig, this.conf.getLAYER_FIELD_B_CONSTRAINT(), this.conf, this.kerasMajorVersion);
        LayerConstraint weightConstraint = KerasConstraintUtils.getConstraintsFromConfig(layerConfig, this.conf.getLAYER_FIELD_W_CONSTRAINT(), this.conf, this.kerasMajorVersion);
        LayerConstraint recurrentConstraint = KerasConstraintUtils.getConstraintsFromConfig(layerConfig, this.conf.getLAYER_FIELD_RECURRENT_CONSTRAINT(), this.conf, this.kerasMajorVersion);
        SimpleRnn.Builder builder = (SimpleRnn.Builder)((SimpleRnn.Builder)((SimpleRnn.Builder)((SimpleRnn.Builder)((SimpleRnn.Builder)((SimpleRnn.Builder)((SimpleRnn.Builder)((SimpleRnn.Builder)((SimpleRnn.Builder)new SimpleRnn.Builder().name(this.layerName)).nOut(KerasLayerUtils.getNOutFromConfig(layerConfig, this.conf))).dropOut(this.dropout)).activation(KerasActivationUtils.getIActivationFromConfig(layerConfig, this.conf))).weightInit(weightInit)).weightInitRecurrent(recurrentWeightInit)).biasInit(0.0)).l1(this.weightL1Regularization)).l2(this.weightL2Regularization);
        if (distribution != null) {
            builder.dist(distribution);
        }
        if (recurrentDistribution != null) {
            builder.dist(recurrentDistribution);
        }
        if (biasConstraint != null) {
            builder.constrainBias(new LayerConstraint[]{biasConstraint});
        }
        if (weightConstraint != null) {
            builder.constrainInputWeights(new LayerConstraint[]{weightConstraint});
        }
        if (recurrentConstraint != null) {
            builder.constrainRecurrent(new LayerConstraint[]{recurrentConstraint});
        }
        this.layer = builder.build();
        if (!this.returnSequences) {
            this.layer = new LastTimeStep(this.layer);
        }
        if (((Boolean)maskingConfig.getFirst()).booleanValue()) {
            this.layer = new MaskZeroLayer(this.layer, ((Double)maskingConfig.getSecond()).doubleValue());
        }
    }

    public Layer getSimpleRnnLayer() {
        return this.layer;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras SimpleRnn layer accepts only one input (received " + inputType.length + ")");
        }
        InputPreProcessor preProcessor = this.getInputPreprocessor(inputType);
        if (preProcessor != null) {
            return preProcessor.getOutputType(inputType[0]);
        }
        return this.getSimpleRnnLayer().getOutputType(-1, inputType[0]);
    }

    @Override
    public int getNumParams() {
        return 3;
    }

    @Override
    public InputPreProcessor getInputPreprocessor(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras SimpleRnn layer accepts only one input (received " + inputType.length + ")");
        }
        return InputTypeUtil.getPreprocessorForInputTypeRnnLayers((InputType)inputType[0], (String)this.layerName);
    }

    public boolean getUnroll() {
        return this.unroll;
    }

    @Override
    public void setWeights(Map<String, INDArray> weights) throws InvalidKerasConfigurationException {
        this.weights = new HashMap();
        if (!weights.containsKey(this.conf.getKERAS_PARAM_NAME_W())) {
            throw new InvalidKerasConfigurationException("Keras SimpleRNN layer does not contain parameter " + this.conf.getKERAS_PARAM_NAME_W());
        }
        INDArray W = weights.get(this.conf.getKERAS_PARAM_NAME_W());
        this.weights.put("W", W);
        if (!weights.containsKey(this.conf.getKERAS_PARAM_NAME_RW())) {
            throw new InvalidKerasConfigurationException("Keras SimpleRNN layer does not contain parameter " + this.conf.getKERAS_PARAM_NAME_RW());
        }
        INDArray RW = weights.get(this.conf.getKERAS_PARAM_NAME_RW());
        this.weights.put("RW", RW);
        if (!weights.containsKey(this.conf.getKERAS_PARAM_NAME_B())) {
            throw new InvalidKerasConfigurationException("Keras SimpleRNN layer does not contain parameter " + this.conf.getKERAS_PARAM_NAME_B());
        }
        INDArray b = weights.get(this.conf.getKERAS_PARAM_NAME_B());
        this.weights.put("b", b);
        if (weights.size() > 3) {
            Set<String> paramNames = weights.keySet();
            paramNames.remove(this.conf.getKERAS_PARAM_NAME_B());
            paramNames.remove(this.conf.getKERAS_PARAM_NAME_W());
            paramNames.remove(this.conf.getKERAS_PARAM_NAME_RW());
            String unknownParamNames = paramNames.toString();
            log.warn("Attemping to set weights for unknown parameters: " + unknownParamNames.substring(1, unknownParamNames.length() - 1));
        }
    }

    public int getNUM_TRAINABLE_PARAMS() {
        return this.NUM_TRAINABLE_PARAMS;
    }

    public boolean isReturnSequences() {
        return this.returnSequences;
    }

    public void setUnroll(boolean unroll) {
        this.unroll = unroll;
    }

    public void setReturnSequences(boolean returnSequences) {
        this.returnSequences = returnSequences;
    }

    public String toString() {
        return "KerasSimpleRnn(NUM_TRAINABLE_PARAMS=" + this.getNUM_TRAINABLE_PARAMS() + ", unroll=" + this.getUnroll() + ", returnSequences=" + this.isReturnSequences() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KerasSimpleRnn)) {
            return false;
        }
        KerasSimpleRnn other = (KerasSimpleRnn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNUM_TRAINABLE_PARAMS() != other.getNUM_TRAINABLE_PARAMS()) {
            return false;
        }
        if (this.getUnroll() != other.getUnroll()) {
            return false;
        }
        return this.isReturnSequences() == other.isReturnSequences();
    }

    protected boolean canEqual(Object other) {
        return other instanceof KerasSimpleRnn;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNUM_TRAINABLE_PARAMS();
        result = result * 59 + (this.getUnroll() ? 79 : 97);
        result = result * 59 + (this.isReturnSequences() ? 79 : 97);
        return result;
    }
}

