/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.pooling;

import org.deeplearning4j.nn.conf.layers.PoolingType;
import org.deeplearning4j.nn.modelimport.keras.config.KerasLayerConfiguration;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;

public class KerasPoolingUtils {
    public static PoolingType mapPoolingType(String className, KerasLayerConfiguration conf) throws UnsupportedKerasConfigurationException {
        PoolingType poolingType;
        if (className.equals(conf.getLAYER_CLASS_NAME_MAX_POOLING_2D()) || className.equals(conf.getLAYER_CLASS_NAME_MAX_POOLING_1D()) || className.equals(conf.getLAYER_CLASS_NAME_MAX_POOLING_3D()) || className.equals(conf.getLAYER_CLASS_NAME_GLOBAL_MAX_POOLING_1D()) || className.equals(conf.getLAYER_CLASS_NAME_GLOBAL_MAX_POOLING_2D())) {
            poolingType = PoolingType.MAX;
        } else if (className.equals(conf.getLAYER_CLASS_NAME_AVERAGE_POOLING_2D()) || className.equals(conf.getLAYER_CLASS_NAME_AVERAGE_POOLING_1D()) || className.equals(conf.getLAYER_CLASS_NAME_AVERAGE_POOLING_3D()) || className.equals(conf.getLAYER_CLASS_NAME_GLOBAL_AVERAGE_POOLING_1D()) || className.equals(conf.getLAYER_CLASS_NAME_GLOBAL_AVERAGE_POOLING_2D())) {
            poolingType = PoolingType.AVG;
        } else {
            throw new UnsupportedKerasConfigurationException("Unsupported Keras pooling layer " + className);
        }
        return poolingType;
    }

    public static int[] mapPoolingDimensions(String className, KerasLayerConfiguration conf) throws UnsupportedKerasConfigurationException {
        int[] dimensions;
        if (className.equals(conf.getLAYER_CLASS_NAME_GLOBAL_MAX_POOLING_1D()) || className.equals(conf.getLAYER_CLASS_NAME_GLOBAL_AVERAGE_POOLING_1D())) {
            dimensions = new int[]{2};
        } else if (className.equals(conf.getLAYER_CLASS_NAME_GLOBAL_MAX_POOLING_2D()) || className.equals(conf.getLAYER_CLASS_NAME_GLOBAL_AVERAGE_POOLING_2D())) {
            dimensions = new int[]{2, 3};
        } else {
            throw new UnsupportedKerasConfigurationException("Unsupported Keras pooling layer " + className);
        }
        return dimensions;
    }
}

