/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.core;

import java.util.Map;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ActivationLayer;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasActivationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasActivation
extends KerasLayer {
    private static final Logger log = LoggerFactory.getLogger(KerasActivation.class);

    public KerasActivation(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasActivation(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        this.layer = ((ActivationLayer.Builder)new ActivationLayer.Builder().name(this.layerName)).activation(KerasActivationUtils.getActivationFromConfig(layerConfig, this.conf)).build();
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras Activation layer accepts only one input (received " + inputType.length + ")");
        }
        return this.getActivationLayer().getOutputType(-1, inputType[0]);
    }

    public ActivationLayer getActivationLayer() {
        return (ActivationLayer)this.layer;
    }
}

