/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers;

import java.util.Map;
import org.deeplearning4j.nn.conf.graph.ElementWiseVertex;
import org.deeplearning4j.nn.conf.graph.MergeVertex;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.modelimport.keras.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.UnsupportedKerasConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasMerge
extends KerasLayer {
    private static final Logger log = LoggerFactory.getLogger(KerasMerge.class);
    public static final String LAYER_FIELD_MODE = "mode";
    public static final String LAYER_MERGE_MODE_SUM = "sum";
    public static final String LAYER_MERGE_MODE_MUL = "mul";
    public static final String LAYER_MERGE_MODE_CONCAT = "concat";
    public static final String LAYER_MERGE_MODE_AVE = "ave";
    public static final String LAYER_MERGE_MODE_COS = "cos";
    public static final String LAYER_MERGE_MODE_DOT = "dot";
    public static final String LAYER_MERGE_MODE_MAX = "max";
    private ElementWiseVertex.Op mergeMode = null;

    public KerasMerge(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasMerge(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        this.mergeMode = this.getMergeMode(layerConfig);
        this.vertex = this.mergeMode == null ? new MergeVertex() : new ElementWiseVertex(this.mergeMode);
    }

    public ElementWiseVertex.Op getMergeMode(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        String mergeMode;
        Map<String, Object> innerConfig = KerasMerge.getInnerLayerConfigFromConfig(layerConfig);
        if (!innerConfig.containsKey(LAYER_FIELD_MODE)) {
            throw new InvalidKerasConfigurationException("Keras Merge layer config missing mode field");
        }
        ElementWiseVertex.Op op = null;
        switch (mergeMode = (String)innerConfig.get(LAYER_FIELD_MODE)) {
            case "sum": {
                op = ElementWiseVertex.Op.Add;
                break;
            }
            case "mul": {
                op = ElementWiseVertex.Op.Product;
                break;
            }
            case "concat": {
                break;
            }
            default: {
                throw new UnsupportedKerasConfigurationException("Keras Merge layer mode " + mergeMode + " not supported");
            }
        }
        return op;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) {
        return this.vertex.getOutputType(-1, inputType);
    }
}

