/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.graph.data.impl;

import java.lang.invoke.CallSite;
import org.deeplearning4j.graph.api.Edge;
import org.deeplearning4j.graph.data.EdgeLineProcessor;

public class DelimitedEdgeLineProcessor
implements EdgeLineProcessor<String> {
    private final String delimiter;
    private final String[] skipLinesStartingWith;
    private final boolean directed;

    public DelimitedEdgeLineProcessor(String delimiter, boolean directed) {
        this(delimiter, directed, null);
    }

    public DelimitedEdgeLineProcessor(String delimiter, boolean directed, String ... skipLinesStartingWith) {
        this.delimiter = delimiter;
        this.skipLinesStartingWith = skipLinesStartingWith;
        this.directed = directed;
    }

    @Override
    public Edge<String> processLine(String line) {
        String[] split;
        if (this.skipLinesStartingWith != null) {
            for (String s : this.skipLinesStartingWith) {
                if (!line.startsWith(s)) continue;
                return null;
            }
        }
        if ((split = line.split(this.delimiter)).length != 2) {
            throw new IllegalArgumentException("Invalid line: expected format \"0" + this.delimiter + "1\"; received \"" + line + "\"");
        }
        int from = Integer.parseInt(split[0]);
        int to = Integer.parseInt(split[1]);
        String edgeName = from + (this.directed ? "->" : "--") + to;
        return new Edge<CallSite>(from, to, (CallSite)((Object)edgeName), this.directed);
    }
}

