/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.fetchers;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import org.apache.commons.io.FileUtils;
import org.deeplearning4j.datasets.fetchers.CacheableDataSet;
import org.deeplearning4j.datasets.fetchers.DataSetType;
import org.nd4j.util.ArchiveUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CacheableExtractableDataSetFetcher
implements CacheableDataSet {
    private static final Logger log = LoggerFactory.getLogger(CacheableExtractableDataSetFetcher.class);
    public static final String DL4J_DIR = "/.deeplearning4j/";
    public static final File ROOT_CACHE_DIR = new File(System.getProperty("user.home"), "/.deeplearning4j/");
    public File LOCAL_CACHE = new File(ROOT_CACHE_DIR, this.localCacheName());

    @Override
    public String dataSetName(DataSetType set) {
        return "";
    }

    @Override
    public String remoteDataUrl() {
        return this.remoteDataUrl(DataSetType.TRAIN);
    }

    @Override
    public long expectedChecksum() {
        return this.expectedChecksum(DataSetType.TRAIN);
    }

    public void downloadAndExtract() throws IOException {
        this.downloadAndExtract(DataSetType.TRAIN);
    }

    public void downloadAndExtract(DataSetType set) throws IOException {
        String localFilename = new File(this.remoteDataUrl(set)).getName();
        File tmpFile = new File(System.getProperty("java.io.tmpdir"), localFilename);
        File cachedFile = new File(ROOT_CACHE_DIR.getAbsolutePath(), localFilename);
        if (this.LOCAL_CACHE.exists() && this.LOCAL_CACHE.listFiles().length < 1) {
            this.LOCAL_CACHE.delete();
        }
        if (!new File(this.LOCAL_CACHE, this.dataSetName(set)).exists()) {
            this.LOCAL_CACHE.mkdirs();
            tmpFile.delete();
            log.info("Downloading dataset to " + tmpFile.getAbsolutePath());
            FileUtils.copyURLToFile((URL)new URL(this.remoteDataUrl(set)), (File)tmpFile);
        } else {
            log.info("Using cached dataset at " + cachedFile.toString());
        }
        if (this.expectedChecksum(set) != 0L) {
            log.info("Verifying download...");
            Adler32 adler = new Adler32();
            FileUtils.checksum((File)tmpFile, (Checksum)adler);
            long localChecksum = adler.getValue();
            log.info("Checksum local is " + localChecksum + ", expecting " + this.expectedChecksum(set));
            if (this.expectedChecksum(set) != localChecksum) {
                log.error("Checksums do not match. Cleaning up files and failing...");
                cachedFile.delete();
                throw new IllegalStateException("Dataset file failed checksum. If this error persists, please open an issue at https://github.com/deeplearning4j/deeplearning4j.");
            }
        }
        ArchiveUtils.unzipFileTo((String)tmpFile.getAbsolutePath(), (String)this.LOCAL_CACHE.getAbsolutePath());
    }

    @Override
    public boolean isCached() {
        return this.LOCAL_CACHE.exists();
    }
}

