/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

package org.deeplearning4j.api.storage;

/**
 * A listener interface, so that classes can be notified of changes to a {@link StatsStorage}
 * implementation
 *
 * @author Alex Black
 */
public interface StatsStorageListener {

    enum EventType {
        NewSessionID, NewTypeID, NewWorkerID, PostMetaData, PostStaticInfo, PostUpdate
    }

    /**
     * Notify will be called whenever an event (new information posted, etc) occurs.
     * Processing these events should ideally be done asynchronously.
     *
     * @param event    Event that occurred
     */
    void notify(StatsStorageEvent event);

}
