/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.modelimport.keras.KerasModelImport;
import org.deeplearning4j.util.ModelGuesserException;
import org.deeplearning4j.util.ModelSerializer;
import org.nd4j.linalg.dataset.api.preprocessor.Normalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelGuesser {
    private static final Logger log = LoggerFactory.getLogger(ModelGuesser.class);

    public static Normalizer<?> loadNormalizer(InputStream is) throws IOException {
        return ModelSerializer.restoreNormalizerFromInputStream((InputStream)is);
    }

    public static Normalizer<?> loadNormalizer(String path) {
        return ModelSerializer.restoreNormalizerFromFile((File)new File(path));
    }

    public static Object loadConfigGuess(String path) throws Exception {
        String input = FileUtils.readFileToString((File)new File(path));
        try {
            return MultiLayerConfiguration.fromJson((String)input);
        }
        catch (Exception e) {
            log.warn("Tried multi layer config from json", (Throwable)e);
            try {
                return KerasModelImport.importKerasModelConfiguration((String)path);
            }
            catch (Exception e1) {
                log.warn("Tried keras model config", (Throwable)e);
                try {
                    return KerasModelImport.importKerasSequentialConfiguration((String)path);
                }
                catch (Exception e2) {
                    log.warn("Tried keras sequence config", (Throwable)e);
                    try {
                        return ComputationGraphConfiguration.fromJson((String)input);
                    }
                    catch (Exception e3) {
                        log.warn("Tried computation graph from json");
                        try {
                            return MultiLayerConfiguration.fromYaml((String)input);
                        }
                        catch (Exception e4) {
                            log.warn("Tried multi layer configuration from yaml");
                            try {
                                return ComputationGraphConfiguration.fromYaml((String)input);
                            }
                            catch (Exception e5) {
                                throw new ModelGuesserException("Unable to load configuration from path " + path + " (invalid config file or not a known config type)");
                            }
                        }
                    }
                }
            }
        }
    }

    public static Object loadConfigGuess(InputStream stream) throws Exception {
        File tmp = new File("model-" + UUID.randomUUID().toString());
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(tmp));
        IOUtils.copy((InputStream)stream, (OutputStream)bufferedOutputStream);
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
        tmp.deleteOnExit();
        Object load = ModelGuesser.loadConfigGuess(tmp.getAbsolutePath());
        tmp.delete();
        return load;
    }

    public static Model loadModelGuess(String path) throws Exception {
        try {
            return ModelSerializer.restoreMultiLayerNetwork((File)new File(path), (boolean)true);
        }
        catch (Exception e) {
            log.warn("Tried multi layer network");
            try {
                return ModelSerializer.restoreComputationGraph((File)new File(path), (boolean)true);
            }
            catch (Exception e1) {
                log.warn("Tried computation graph");
                try {
                    return ModelSerializer.restoreMultiLayerNetwork((File)new File(path), (boolean)false);
                }
                catch (Exception e4) {
                    try {
                        return ModelSerializer.restoreComputationGraph((File)new File(path), (boolean)false);
                    }
                    catch (Exception e5) {
                        try {
                            return KerasModelImport.importKerasModelAndWeights((String)path);
                        }
                        catch (Exception e2) {
                            log.warn("Tried multi layer network keras");
                            try {
                                return KerasModelImport.importKerasSequentialModelAndWeights((String)path);
                            }
                            catch (Exception e3) {
                                throw new ModelGuesserException("Unable to load model from path " + path + " (invalid model file or not a known model type)");
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static Model loadModelGuess(InputStream stream) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

