/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.parallelism;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.memory.conf.WorkspaceConfiguration;
import org.nd4j.linalg.api.memory.enums.AllocationPolicy;
import org.nd4j.linalg.api.memory.enums.ResetPolicy;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.MultiDataSet;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class MagicQueue<T>
implements BlockingQueue<T> {
    private static final Logger log = LoggerFactory.getLogger(MagicQueue.class);
    protected final List<LinkedBlockingQueue<T>> backingQueues;
    protected final AtomicInteger nextBucket = new AtomicInteger(0);
    protected final int numberOfBuckets;
    protected final List<QueueHandler> handlers;
    protected int capacity = 10;
    protected Mode mode = Mode.THREADED;
    protected Type type = null;
    protected AtomicInteger interleavedCounter = new AtomicInteger(0);
    protected AtomicInteger interleavedPutter = new AtomicInteger(0);
    protected AtomicLong cntPut = new AtomicLong(0L);
    protected AtomicLong cntGet = new AtomicLong(0L);

    protected MagicQueue(int numberOfFlows, int capacity, Type type) {
        this.backingQueues = new ArrayList<LinkedBlockingQueue<T>>();
        this.type = type;
        this.capacity = capacity;
        this.handlers = new ArrayList<QueueHandler>();
        if (numberOfFlows > 1) {
            for (int i = 0; i < numberOfFlows; ++i) {
                LinkedBlockingQueue queue = new LinkedBlockingQueue(capacity);
                this.backingQueues.add(queue);
                QueueHandler handler = new QueueHandler(queue, capacity, i, type);
                Nd4j.getAffinityManager().attachThreadToDevice((Thread)handler, Integer.valueOf(i));
                handler.start();
                this.handlers.add(handler);
            }
        } else {
            LinkedBlockingQueue queue = new LinkedBlockingQueue();
            this.backingQueues.add(queue);
        }
        this.numberOfBuckets = numberOfFlows;
    }

    @Override
    public int size() {
        if (this.mode == Mode.THREADED) {
            if (this.numberOfBuckets > 1) {
                long cnt = 0L;
                for (int i = 0; i < this.numberOfBuckets; ++i) {
                    cnt += (long)this.backingQueues.get(i).size();
                }
                return (int)Math.floor(cnt / (long)this.numberOfBuckets);
            }
            return this.backingQueues.get(0).size();
        }
        return (int)(this.cntPut.get() - this.cntGet.get());
    }

    protected int size(int deviceId) {
        if (deviceId >= this.backingQueues.size()) {
            throw new RuntimeException("DeviceID exceeds number of actual backing queues");
        }
        return this.backingQueues.get(deviceId).size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() < 1;
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int drainTo(Collection<? super T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int drainTo(Collection<? super T> c, int maxElements) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T dataSet) {
        this.cntPut.incrementAndGet();
        if (this.numberOfBuckets > 1) {
            MagicQueue magicQueue = this;
            synchronized (magicQueue) {
                if (this.nextBucket.get() >= this.backingQueues.size()) {
                    this.nextBucket.set(0);
                }
            }
            this.handlers.get(this.nextBucket.getAndIncrement()).put(dataSet);
            return true;
        }
        this.backingQueues.get(0).add(dataSet);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        for (T ds : c) {
            boolean result = this.add(ds);
            if (result) continue;
            return result;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        for (Queue queue : this.backingQueues) {
            queue.clear();
        }
        this.cntPut.set(0L);
        this.cntGet.set(0L);
    }

    @Override
    public boolean offer(T dataSet) {
        if (this.numberOfBuckets > 1) {
            int deviceId = Nd4j.getAffinityManager().getDeviceForCurrentThread();
            boolean res = this.backingQueues.get(deviceId).offer(dataSet);
            if (res) {
                this.cntPut.incrementAndGet();
            }
            return res;
        }
        boolean result = this.backingQueues.get(0).offer(dataSet);
        if (result) {
            this.cntPut.incrementAndGet();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(T dataSet) throws InterruptedException {
        if (this.numberOfBuckets > 1) {
            MagicQueue magicQueue = this;
            synchronized (magicQueue) {
                if (this.nextBucket.get() >= this.backingQueues.size()) {
                    this.nextBucket.set(0);
                }
            }
            this.handlers.get(this.nextBucket.getAndIncrement()).put(dataSet);
        } else {
            this.backingQueues.get(0).add(dataSet);
        }
        this.cntPut.incrementAndGet();
    }

    @Override
    public boolean offer(T dataSet, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.numberOfBuckets > 1) {
            int deviceId = Nd4j.getAffinityManager().getDeviceForCurrentThread();
            boolean res = this.backingQueues.get(deviceId).offer(dataSet, timeout, unit);
            if (res) {
                this.cntPut.incrementAndGet();
            }
            return res;
        }
        boolean res = this.backingQueues.get(0).offer(dataSet, timeout, unit);
        if (res) {
            this.cntPut.incrementAndGet();
        }
        return res;
    }

    @Override
    public T take() throws InterruptedException {
        try {
            if (this.mode == Mode.THREADED) {
                if (this.numberOfBuckets > 1) {
                    int deviceId = Nd4j.getAffinityManager().getDeviceForCurrentThread();
                    T t = this.backingQueues.get(deviceId).take();
                    return t;
                }
                T deviceId = this.backingQueues.get(0).take();
                return deviceId;
            }
            T ds = this.backingQueues.get(this.interleavedCounter.getAndIncrement()).take();
            if (this.interleavedCounter.get() >= this.backingQueues.size()) {
                this.interleavedCounter.set(0);
            }
            T t = ds;
            return t;
        }
        catch (InterruptedException e) {
            throw e;
        }
        finally {
            this.cntGet.incrementAndGet();
        }
    }

    @Override
    public T remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T poll(long time, TimeUnit timeUnit) throws InterruptedException {
        if (this.mode == Mode.THREADED) {
            if (this.numberOfBuckets > 1) {
                int deviceId = Nd4j.getAffinityManager().getDeviceForCurrentThread();
                T ds = this.backingQueues.get(deviceId).poll(time, timeUnit);
                if (ds != null) {
                    this.cntGet.incrementAndGet();
                }
                return ds;
            }
            T ds = this.backingQueues.get(0).poll(time, timeUnit);
            if (ds != null) {
                this.cntGet.incrementAndGet();
            }
            return ds;
        }
        T ds = this.backingQueues.get(this.interleavedCounter.getAndIncrement()).poll(time, timeUnit);
        if (this.interleavedCounter.get() >= this.backingQueues.size()) {
            this.interleavedCounter.set(0);
        }
        if (ds != null) {
            this.cntGet.incrementAndGet();
        }
        return ds;
    }

    @Override
    public int remainingCapacity() {
        return 0;
    }

    @Override
    public T poll() {
        if (this.mode == Mode.THREADED) {
            if (this.numberOfBuckets > 1) {
                int deviceId = Nd4j.getAffinityManager().getDeviceForCurrentThread();
                T ds = this.backingQueues.get(deviceId).poll();
                if (ds != null) {
                    this.cntGet.incrementAndGet();
                }
                return ds;
            }
            T ds = this.backingQueues.get(0).poll();
            if (ds != null) {
                this.cntGet.incrementAndGet();
            }
            return ds;
        }
        T ds = this.backingQueues.get(this.interleavedCounter.getAndIncrement()).poll();
        if (this.interleavedCounter.get() >= this.backingQueues.size()) {
            this.interleavedCounter.set(0);
        }
        if (ds != null) {
            this.cntGet.incrementAndGet();
        }
        return ds;
    }

    @Override
    public T element() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T peek() {
        throw new UnsupportedOperationException();
    }

    private class QueueHandler
    extends Thread
    implements Runnable {
        private final BlockingQueue<T> targetQueue;
        private final LinkedBlockingQueue<T> bufferQueue;
        private final int device;
        private final int capacity;
        private final Type type;

        public QueueHandler(BlockingQueue<T> queue, int capacity, int device, Type type) {
            this.targetQueue = queue;
            this.type = type;
            this.bufferQueue = new LinkedBlockingQueue(capacity);
            this.capacity = capacity;
            this.device = device;
            this.setDaemon(true);
            this.setName("MQ_THREAD " + device);
        }

        public void put(T dataSet) {
            try {
                this.bufferQueue.put(dataSet);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Nd4j.create((int)1);
            WorkspaceConfiguration configuration = null;
            String id = "MQAD_THREAD";
            log.info("MQAD_THREAD started on device [{}/{}]", (Object)this.device, (Object)Nd4j.getAffinityManager().getDeviceForCurrentThread());
            try {
                while (true) {
                    MemoryWorkspace workspace;
                    block38: {
                        Throwable throwable;
                        DataSet ds = null;
                        MultiDataSet mds = null;
                        if (this.type == Type.DS) {
                            ds = (DataSet)this.bufferQueue.poll(1L, TimeUnit.SECONDS);
                        } else {
                            mds = (MultiDataSet)this.bufferQueue.poll(1L, TimeUnit.SECONDS);
                        }
                        if (ds != null) {
                            if (configuration == null) {
                                long initSize = Math.max(ds.getMemoryFootprint() * (long)this.capacity, 0xA00000L);
                                configuration = WorkspaceConfiguration.builder().initialSize(initSize).overallocationLimit(1.0).policyReset(ResetPolicy.ENDOFBUFFER_REACHED).policyAllocation(AllocationPolicy.OVERALLOCATE).build();
                            }
                            workspace = Nd4j.getWorkspaceManager().getAndActivateWorkspace(configuration, id);
                            throwable = null;
                            try {
                                ds.migrate();
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (workspace != null) {
                                    if (throwable != null) {
                                        try {
                                            workspace.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                    } else {
                                        workspace.close();
                                    }
                                }
                            }
                            this.targetQueue.put(ds);
                            continue;
                        }
                        if (mds == null) continue;
                        if (configuration == null) {
                            long initSize = Math.max(mds.getMemoryFootprint() * (long)this.capacity, 0xA00000L);
                            configuration = WorkspaceConfiguration.builder().initialSize(initSize).overallocationLimit(1.0).policyReset(ResetPolicy.ENDOFBUFFER_REACHED).policyAllocation(AllocationPolicy.OVERALLOCATE).build();
                        }
                        workspace = Nd4j.getWorkspaceManager().getAndActivateWorkspace(configuration, id);
                        throwable = null;
                        try {
                            if (mds.getFeaturesMaskArrays() != null) {
                                for (int i = 0; i < mds.getFeaturesMaskArrays().length; ++i) {
                                    mds.getFeaturesMaskArrays()[i] = mds.getFeaturesMaskArrays()[i].migrate();
                                }
                            }
                            if (mds.getLabelsMaskArrays() != null) {
                                for (int i = 0; i < mds.getLabelsMaskArrays().length; ++i) {
                                    mds.getLabelsMaskArrays()[i] = mds.getLabelsMaskArrays()[i].migrate();
                                }
                            }
                            if (mds.getLabels() != null) {
                                for (int i = 0; i < mds.getLabels().length; ++i) {
                                    mds.getLabels()[i] = mds.getLabels()[i].migrate();
                                }
                            }
                            if (mds.getFeatures() != null) {
                                for (int i = 0; i < mds.getFeatures().length; ++i) {
                                    mds.getFeatures()[i] = mds.getFeatures()[i].migrate();
                                }
                            }
                            this.targetQueue.put(mds);
                            if (workspace == null) continue;
                            if (throwable == null) break block38;
                        }
                        catch (Throwable throwable4) {
                            try {
                                throwable = throwable4;
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (workspace == null) throw throwable5;
                                if (throwable == null) {
                                    workspace.close();
                                    throw throwable5;
                                }
                                try {
                                    workspace.close();
                                    throw throwable5;
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                    throw throwable5;
                                }
                            }
                        }
                        try {
                            workspace.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                        continue;
                    }
                    workspace.close();
                }
            }
            catch (InterruptedException e) {
                log.warn("Got InterruptedException...");
                return;
            }
        }
    }

    public static class Builder {
        private int numberOfBuckets = Nd4j.getAffinityManager().getNumberOfDevices();
        private int capacity = 16;
        private Mode mode = Mode.THREADED;
        private Type type = Type.DS;

        public Builder setNumberOfBuckets(int number) {
            this.numberOfBuckets = number;
            return this;
        }

        public Builder setType(@NonNull Type type) {
            if (type == null) {
                throw new NullPointerException("type");
            }
            this.type = type;
            return this;
        }

        public Builder setMode(@NonNull Mode mode) {
            if (mode == null) {
                throw new NullPointerException("mode");
            }
            this.mode = mode;
            return this;
        }

        public Builder setCapacityPerFlow(int capacityPerFlow) {
            if (capacityPerFlow <= 0) {
                throw new ND4JIllegalStateException("Capacity per flow value should be positive value");
            }
            this.capacity = capacityPerFlow;
            return this;
        }

        public MagicQueue build() {
            if (this.numberOfBuckets < 1) {
                this.numberOfBuckets = Nd4j.getAffinityManager().getNumberOfDevices();
            }
            MagicQueue queue = new MagicQueue(this.numberOfBuckets, this.capacity, this.type);
            queue.mode = this.mode;
            return queue;
        }
    }

    public static enum Type {
        DS,
        MDS;

    }

    public static enum Mode {
        THREADED,
        SEQUENTIAL;

    }
}

