/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.parallelism;

import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncIterator<T>
implements Iterator<T> {
    private static final Logger log = LoggerFactory.getLogger(AsyncIterator.class);
    protected BlockingQueue<T> buffer;
    protected ReaderThread<T> thread;
    protected Iterator<T> iterator;
    protected T terminator = new Object();
    protected T nextElement;
    protected AtomicBoolean shouldWork = new AtomicBoolean(true);

    public AsyncIterator(@NonNull Iterator<T> iterator, int bufferSize) {
        if (iterator == null) {
            throw new NullPointerException("iterator");
        }
        this.buffer = new LinkedBlockingQueue<T>(bufferSize);
        this.iterator = iterator;
        this.thread = new ReaderThread<T>(iterator, this.buffer, this.terminator);
        this.thread.start();
    }

    public AsyncIterator(@NonNull Iterator<T> iterator) {
        this(iterator, 1024);
        if (iterator == null) {
            throw new NullPointerException("iterator");
        }
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.nextElement != null && this.nextElement != this.terminator) {
                return true;
            }
            this.nextElement = this.buffer.take();
            return this.nextElement != this.terminator;
        }
        catch (Exception e) {
            log.error("Premature end of loop!");
            return false;
        }
    }

    @Override
    public T next() {
        T temp = this.nextElement;
        this.nextElement = null;
        return temp;
    }

    @Override
    public void remove() {
    }

    public void shutdown() {
        if (this.shouldWork.get()) {
            this.shouldWork.set(false);
            this.thread.interrupt();
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.nextElement = this.terminator;
        }
    }

    public BlockingQueue<T> getBuffer() {
        return this.buffer;
    }

    public T getTerminator() {
        return this.terminator;
    }

    private class ReaderThread<T>
    extends Thread
    implements Runnable {
        private BlockingQueue<T> buffer;
        private Iterator<T> iterator;
        private T terminator;

        public ReaderThread(Iterator<T> iterator, BlockingQueue<T> buffer, T terminator) {
            this.buffer = buffer;
            this.iterator = iterator;
            this.terminator = terminator;
            this.setDaemon(true);
            this.setName("AsyncIterator Reader thread");
        }

        @Override
        public void run() {
            try {
                while (this.iterator.hasNext() && AsyncIterator.this.shouldWork.get()) {
                    T smth = this.iterator.next();
                    if (smth == null) continue;
                    this.buffer.put(smth);
                }
                this.buffer.put(this.terminator);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                AsyncIterator.this.shouldWork.set(false);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

