/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.fetchers;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.deeplearning4j.base.EmnistFetcher;
import org.deeplearning4j.datasets.fetchers.MnistDataFetcher;
import org.deeplearning4j.datasets.iterator.impl.EmnistDataSetIterator;
import org.deeplearning4j.datasets.mnist.MnistManager;

public class EmnistDataFetcher
extends MnistDataFetcher {
    protected static final String EMNIST_ROOT = TEMP_ROOT + File.separator + "EMNIST" + File.separator;
    protected EmnistFetcher fetcher;

    public EmnistDataFetcher(EmnistDataSetIterator.Set dataSet, boolean binarize, boolean train, boolean shuffle, long rngSeed) throws IOException {
        String labels;
        String images;
        this.fetcher = new EmnistFetcher(dataSet);
        if (!this.emnistExists(this.fetcher)) {
            this.fetcher.downloadAndUntar();
        }
        if (train) {
            images = EMNIST_ROOT + this.fetcher.getTrainingFilesFilename_unzipped();
            labels = EMNIST_ROOT + this.fetcher.getTrainingFileLabelsFilename_unzipped();
            this.totalExamples = EmnistDataSetIterator.numExamplesTrain(dataSet);
        } else {
            images = EMNIST_ROOT + this.fetcher.getTestFilesFilename_unzipped();
            labels = EMNIST_ROOT + this.fetcher.getTestFileLabelsFilename_unzipped();
            this.totalExamples = EmnistDataSetIterator.numExamplesTest(dataSet);
        }
        try {
            this.man = new MnistManager(images, labels, this.totalExamples);
        }
        catch (Exception e) {
            e.printStackTrace();
            FileUtils.deleteDirectory((File)new File(EMNIST_ROOT));
            new EmnistFetcher(dataSet).downloadAndUntar();
            this.man = new MnistManager(images, labels, this.totalExamples);
        }
        this.numOutcomes = EmnistDataSetIterator.numLabels(dataSet);
        this.binarize = binarize;
        this.cursor = 0;
        this.inputColumns = this.man.getImages().getEntryLength();
        this.train = train;
        this.shuffle = shuffle;
        this.order = new int[this.totalExamples];
        for (int i = 0; i < this.order.length; ++i) {
            this.order[i] = i;
        }
        this.rng = new Random(rngSeed);
        this.reset();
        this.oneIndexed = dataSet == EmnistDataSetIterator.Set.LETTERS;
        this.fOrder = true;
    }

    private boolean emnistExists(EmnistFetcher e) {
        File f = new File(EMNIST_ROOT, e.getTrainingFilesFilename_unzipped());
        if (!f.exists()) {
            return false;
        }
        f = new File(EMNIST_ROOT, e.getTrainingFileLabelsFilename_unzipped());
        if (!f.exists()) {
            return false;
        }
        f = new File(EMNIST_ROOT, e.getTestFilesFilename_unzipped());
        if (!f.exists()) {
            return false;
        }
        f = new File(EMNIST_ROOT, e.getTestFileLabelsFilename_unzipped());
        return f.exists();
    }
}

