/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator.impl;

import java.util.List;
import org.datavec.image.loader.CifarLoader;
import org.datavec.image.transform.ImageTransform;
import org.deeplearning4j.datasets.datavec.RecordReaderDataSetIterator;
import org.nd4j.linalg.dataset.api.DataSet;

public class CifarDataSetIterator
extends RecordReaderDataSetIterator {
    protected static final int HEIGHT = 32;
    protected static final int WIDTH = 32;
    protected static final int CHANNELS = 3;
    protected final CifarLoader loader;
    protected final int numExamples;
    protected final boolean useSpecialPreProcessCifar;
    protected final boolean train;
    protected final ImageTransform imageTransform;
    protected int exampleCount = 0;
    protected boolean overshot = false;

    public CifarDataSetIterator(int batchSize, int numExamples) {
        this(batchSize, numExamples, true);
    }

    public CifarDataSetIterator(int batchSize, int numExamples, boolean train) {
        this(batchSize, numExamples, new int[]{32, 32, 3}, 10, null, false, train);
    }

    public CifarDataSetIterator(int batchSize, int[] imgDim) {
        this(batchSize, 50000, imgDim);
    }

    public CifarDataSetIterator(int batchSize, int numExamples, int[] imgDim) {
        this(batchSize, numExamples, imgDim, true);
    }

    public CifarDataSetIterator(int batchSize, int numExamples, int[] imgDim, boolean train) {
        this(batchSize, numExamples, imgDim, false, train);
    }

    public CifarDataSetIterator(int batchSize, int numExamples, int[] imgDim, boolean useSpecialPreProcessCifar, boolean train) {
        this(batchSize, numExamples, imgDim, 10, null, useSpecialPreProcessCifar, train);
    }

    public CifarDataSetIterator(int batchSize, int numExamples, int[] imgDim, int numPossibleLables, ImageTransform imageTransform, boolean useSpecialPreProcessCifar, boolean train) {
        super(null, batchSize, 1, numExamples);
        this.loader = new CifarLoader(imgDim[0], imgDim[1], imgDim[2], imageTransform, train, useSpecialPreProcessCifar);
        int totalExamples = train ? 50000 : 10000;
        this.numExamples = numExamples > totalExamples ? totalExamples : numExamples;
        this.numPossibleLabels = numPossibleLables;
        this.imageTransform = imageTransform;
        this.useSpecialPreProcessCifar = useSpecialPreProcessCifar;
        this.train = train;
    }

    @Override
    public org.nd4j.linalg.dataset.DataSet next(int batchSize) {
        if (this.useCurrent) {
            this.useCurrent = false;
            return this.last;
        }
        org.nd4j.linalg.dataset.DataSet result = this.useSpecialPreProcessCifar ? this.loader.next(batchSize, this.exampleCount) : this.loader.next(batchSize);
        this.exampleCount += batchSize;
        ++this.batchNum;
        if (result.getFeatureMatrix() == null || result == new org.nd4j.linalg.dataset.DataSet() || this.maxNumBatches > -1 && this.batchNum >= this.maxNumBatches) {
            this.overshot = true;
            return this.last;
        }
        if (this.preProcessor != null) {
            this.preProcessor.preProcess((DataSet)result);
        }
        this.last = result;
        if (this.loader.getLabels() != null) {
            result.setLabelNames(this.loader.getLabels());
        }
        return result;
    }

    @Override
    public boolean hasNext() {
        return this.exampleCount < this.numExamples && (this.maxNumBatches == -1 || this.batchNum < this.maxNumBatches) && !this.overshot;
    }

    @Override
    public int totalExamples() {
        return this.numExamples;
    }

    @Override
    public void reset() {
        this.exampleCount = 0;
        this.overshot = false;
        this.batchNum = 0;
        this.loader.reset();
    }

    @Override
    public List<String> getLabels() {
        return this.loader.getLabels();
    }

    @Override
    public boolean asyncSupported() {
        return true;
    }
}

