/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.modelimport.keras.KerasModelImport;
import org.deeplearning4j.util.ModelSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelGuesser {
    private static final Logger log = LoggerFactory.getLogger(ModelGuesser.class);

    public static Object loadConfigGuess(String path) throws Exception {
        String input = FileUtils.readFileToString((File)new File(path));
        try {
            return MultiLayerConfiguration.fromJson((String)input);
        }
        catch (Exception e) {
            log.warn("Tried multi layer config from json", (Throwable)e);
            try {
                return KerasModelImport.importKerasModelConfiguration((String)path);
            }
            catch (Exception e1) {
                log.warn("Tried keras model config", (Throwable)e);
                try {
                    return KerasModelImport.importKerasSequentialConfiguration((String)path);
                }
                catch (Exception e2) {
                    log.warn("Tried keras sequence config", (Throwable)e);
                    try {
                        return ComputationGraphConfiguration.fromJson((String)input);
                    }
                    catch (Exception e3) {
                        log.warn("Tried computation graph from json");
                        try {
                            return MultiLayerConfiguration.fromYaml((String)input);
                        }
                        catch (Exception e4) {
                            log.warn("Tried multi layer configuration from yaml");
                            return ComputationGraphConfiguration.fromYaml((String)input);
                        }
                    }
                }
            }
        }
    }

    public static Object loadConfigGuess(InputStream stream) throws Exception {
        File tmp = new File("model-" + UUID.randomUUID().toString());
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(tmp));
        IOUtils.copy((InputStream)stream, (OutputStream)bufferedOutputStream);
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
        tmp.deleteOnExit();
        Object load = ModelGuesser.loadConfigGuess(tmp.getAbsolutePath());
        tmp.delete();
        return load;
    }

    public static Model loadModelGuess(String path) throws Exception {
        try {
            return ModelSerializer.restoreMultiLayerNetwork((File)new File(path), (boolean)true);
        }
        catch (Exception e) {
            log.warn("Tried multi layer network");
            try {
                return ModelSerializer.restoreComputationGraph((File)new File(path), (boolean)true);
            }
            catch (Exception e1) {
                log.warn("Tried computation graph");
                try {
                    return KerasModelImport.importKerasModelAndWeights((String)path);
                }
                catch (Exception e2) {
                    log.warn("Tried multi layer network keras");
                    return KerasModelImport.importKerasSequentialModelAndWeights((String)path);
                }
            }
        }
    }

    public static Model loadModelGuess(InputStream stream) throws Exception {
        try {
            return ModelSerializer.restoreMultiLayerNetwork((InputStream)stream, (boolean)true);
        }
        catch (Exception e) {
            try {
                return ModelSerializer.restoreComputationGraph((InputStream)stream, (boolean)true);
            }
            catch (Exception e1) {
                try {
                    return KerasModelImport.importKerasModelAndWeights((InputStream)stream);
                }
                catch (Exception e2) {
                    return KerasModelImport.importKerasSequentialModelAndWeights((InputStream)stream);
                }
            }
        }
    }
}

