/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.clustering.algorithm.condition;

import java.io.Serializable;
import org.deeplearning4j.clustering.algorithm.condition.ClusteringAlgorithmCondition;
import org.deeplearning4j.clustering.algorithm.iteration.IterationHistory;
import org.nd4j.linalg.indexing.conditions.Condition;
import org.nd4j.linalg.indexing.conditions.LessThan;

public class VarianceVariationCondition
implements ClusteringAlgorithmCondition,
Serializable {
    private Condition varianceVariationCondition;
    private int period;

    protected VarianceVariationCondition() {
    }

    protected VarianceVariationCondition(Condition varianceVariationCondition, int period) {
        this.varianceVariationCondition = varianceVariationCondition;
        this.period = period;
    }

    public static VarianceVariationCondition varianceVariationLessThan(double varianceVariation, int period) {
        LessThan condition = new LessThan((Number)varianceVariation);
        return new VarianceVariationCondition((Condition)condition, period);
    }

    @Override
    public boolean isSatisfied(IterationHistory iterationHistory) {
        if (iterationHistory.getIterationCount() <= this.period) {
            return false;
        }
        int j = iterationHistory.getIterationCount();
        for (int i = 0; i < this.period; ++i) {
            double variation = iterationHistory.getIterationInfo(j - i).getClusterSetInfo().getPointDistanceFromClusterVariance();
            variation -= iterationHistory.getIterationInfo(j - i - 1).getClusterSetInfo().getPointDistanceFromClusterVariance();
            if (this.varianceVariationCondition.apply((Number)(variation /= iterationHistory.getIterationInfo(j - i - 1).getClusterSetInfo().getPointDistanceFromClusterVariance())).booleanValue()) continue;
            return false;
        }
        return true;
    }
}

