/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.clustering.cluster;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class Point
implements Serializable {
    private static final long serialVersionUID = -6658028541426027226L;
    private String id = UUID.randomUUID().toString();
    private String label;
    private INDArray array;

    public Point(INDArray array) {
        this.array = array;
    }

    public Point(String id, INDArray array) {
        this.id = id;
        this.array = array;
    }

    public Point(String id, String label, double[] data) {
        this(id, label, Nd4j.create((double[])data));
    }

    public Point(String id, String label, INDArray array) {
        this.id = id;
        this.label = label;
        this.array = array;
    }

    public static List<Point> toPoints(List<INDArray> vectors) {
        ArrayList<Point> points = new ArrayList<Point>();
        for (INDArray vector : vectors) {
            points.add(new Point(vector));
        }
        return points;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public INDArray getArray() {
        return this.array;
    }

    public void setArray(INDArray array) {
        this.array = array;
    }
}

