/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.clustering.algorithm.strategy;

import org.deeplearning4j.clustering.algorithm.condition.ClusteringAlgorithmCondition;
import org.deeplearning4j.clustering.algorithm.condition.ConvergenceCondition;
import org.deeplearning4j.clustering.algorithm.condition.FixedIterationCountCondition;
import org.deeplearning4j.clustering.algorithm.strategy.ClusteringStrategy;
import org.deeplearning4j.clustering.algorithm.strategy.ClusteringStrategyType;

public abstract class BaseClusteringStrategy
implements ClusteringStrategy {
    protected ClusteringStrategyType type;
    protected Integer initialClusterCount;
    protected ClusteringAlgorithmCondition optimizationPhaseCondition;
    protected ClusteringAlgorithmCondition terminationCondition;
    protected String distanceFunction;
    protected boolean allowEmptyClusters;

    protected BaseClusteringStrategy(ClusteringStrategyType type, Integer initialClusterCount, String distanceFunction, boolean allowEmptyClusters) {
        this.type = type;
        this.initialClusterCount = initialClusterCount;
        this.distanceFunction = distanceFunction;
        this.allowEmptyClusters = allowEmptyClusters;
    }

    @Override
    public BaseClusteringStrategy endWhenIterationCountEquals(int maxIterationCount) {
        this.setTerminationCondition(FixedIterationCountCondition.iterationCountGreaterThan(maxIterationCount));
        return this;
    }

    @Override
    public BaseClusteringStrategy endWhenDistributionVariationRateLessThan(double rate) {
        this.setTerminationCondition(ConvergenceCondition.distributionVariationRateLessThan(rate));
        return this;
    }

    @Override
    public boolean isStrategyOfType(ClusteringStrategyType type) {
        return type.equals((Object)this.type);
    }

    @Override
    public Integer getInitialClusterCount() {
        return this.initialClusterCount;
    }

    public void setInitialClusterCount(Integer clusterCount) {
        this.initialClusterCount = clusterCount;
    }

    @Override
    public String getDistanceFunction() {
        return this.distanceFunction;
    }

    public void setDistanceFunction(String distanceFunction) {
        this.distanceFunction = distanceFunction;
    }

    @Override
    public boolean isAllowEmptyClusters() {
        return this.allowEmptyClusters;
    }

    public void setAllowEmptyClusters(boolean allowEmptyClusters) {
        this.allowEmptyClusters = allowEmptyClusters;
    }

    @Override
    public ClusteringStrategyType getType() {
        return this.type;
    }

    protected void setType(ClusteringStrategyType type) {
        this.type = type;
    }

    public ClusteringAlgorithmCondition getOptimizationPhaseCondition() {
        return this.optimizationPhaseCondition;
    }

    protected void setOptimizationPhaseCondition(ClusteringAlgorithmCondition optimizationPhaseCondition) {
        this.optimizationPhaseCondition = optimizationPhaseCondition;
    }

    @Override
    public ClusteringAlgorithmCondition getTerminationCondition() {
        return this.terminationCondition;
    }

    protected void setTerminationCondition(ClusteringAlgorithmCondition terminationCondition) {
        this.terminationCondition = terminationCondition;
    }
}

