/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.clustering.kmeans;

import org.deeplearning4j.clustering.algorithm.BaseClusteringAlgorithm;
import org.deeplearning4j.clustering.algorithm.strategy.ClusteringStrategy;
import org.deeplearning4j.clustering.algorithm.strategy.FixedClusterCountStrategy;

public class KMeansClustering
extends BaseClusteringAlgorithm {
    private static final long serialVersionUID = 8476951388145944776L;

    protected KMeansClustering(ClusteringStrategy clusteringStrategy) {
        super(clusteringStrategy);
    }

    public static KMeansClustering setup(int clusterCount, int maxIterationCount, String distanceFunction) {
        FixedClusterCountStrategy clusteringStrategy = FixedClusterCountStrategy.setup(clusterCount, distanceFunction);
        clusteringStrategy.endWhenIterationCountEquals(maxIterationCount);
        return new KMeansClustering(clusteringStrategy);
    }

    public static KMeansClustering setup(int clusterCount, double minDistributionVariationRate, String distanceFunction, boolean allowEmptyClusters) {
        FixedClusterCountStrategy clusteringStrategy = FixedClusterCountStrategy.setup(clusterCount, distanceFunction);
        clusteringStrategy.endWhenDistributionVariationRateLessThan(minDistributionVariationRate);
        return new KMeansClustering(clusteringStrategy);
    }
}

