/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.plot;

import org.deeplearning4j.datasets.mnist.draw.DrawReconstruction;
import org.deeplearning4j.nn.api.Layer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;

public class NeuralNetworkReconstructionRender {
    private DataSetIterator iter;
    private Layer network;

    public NeuralNetworkReconstructionRender(DataSetIterator iter, Layer network) {
        this.iter = iter;
        this.network = network;
    }

    public void draw() throws InterruptedException {
        while (this.iter.hasNext()) {
            DataSet first = (DataSet)this.iter.next();
            INDArray reconstruct = this.network.activate(first.getFeatureMatrix());
            for (int j = 0; j < first.numExamples(); ++j) {
                INDArray draw1 = first.get(j).getFeatureMatrix().mul((Number)255);
                INDArray reconstructed2 = reconstruct.getRow(j);
                INDArray draw2 = reconstructed2.mul((Number)255);
                DrawReconstruction d = new DrawReconstruction(draw1);
                d.title = "REAL";
                d.draw();
                DrawReconstruction d2 = new DrawReconstruction(draw2, 1000, 1000);
                d2.title = "TEST";
                d2.draw();
                Thread.sleep(10000L);
                d.frame.dispose();
                d2.frame.dispose();
            }
        }
    }
}

