/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.preprocessor;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.preprocessor.BaseInputPreProcessor;
import org.nd4j.linalg.api.ndarray.INDArray;

public class ComposableInputPreProcessor
extends BaseInputPreProcessor {
    private InputPreProcessor[] inputPreProcessors;

    @JsonCreator
    public ComposableInputPreProcessor(InputPreProcessor ... inputPreProcessors) {
        this.inputPreProcessors = inputPreProcessors;
    }

    @Override
    public INDArray preProcess(INDArray input, int miniBatchSize) {
        for (InputPreProcessor preProcessor : this.inputPreProcessors) {
            input = preProcessor.preProcess(input, miniBatchSize);
        }
        return input;
    }

    @Override
    public INDArray backprop(INDArray output, int miniBatchSize) {
        for (int i = this.inputPreProcessors.length - 1; i >= 0; --i) {
            output = this.inputPreProcessors[i].backprop(output, miniBatchSize);
        }
        return output;
    }

    @Override
    public ComposableInputPreProcessor clone() {
        ComposableInputPreProcessor clone = (ComposableInputPreProcessor)super.clone();
        if (clone.inputPreProcessors != null) {
            InputPreProcessor[] processors = new InputPreProcessor[clone.inputPreProcessors.length];
            for (int i = 0; i < clone.inputPreProcessors.length; ++i) {
                processors[i] = clone.inputPreProcessors[i].clone();
            }
            clone.inputPreProcessors = processors;
        }
        return clone;
    }

    public InputPreProcessor[] getInputPreProcessors() {
        return this.inputPreProcessors;
    }

    public void setInputPreProcessors(InputPreProcessor[] inputPreProcessors) {
        this.inputPreProcessors = inputPreProcessors;
    }

    public String toString() {
        return "ComposableInputPreProcessor(inputPreProcessors=" + Arrays.deepToString(this.getInputPreProcessors()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComposableInputPreProcessor)) {
            return false;
        }
        ComposableInputPreProcessor other = (ComposableInputPreProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.deepEquals(this.getInputPreProcessors(), other.getInputPreProcessors());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ComposableInputPreProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getInputPreProcessors());
        return result;
    }
}

