/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.datavec;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.datavec.api.records.reader.RecordReader;
import org.datavec.api.records.reader.SequenceRecordReader;
import org.datavec.api.writable.Writable;
import org.datavec.common.data.NDArrayWritable;
import org.deeplearning4j.berkeley.Pair;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.MultiDataSet;
import org.nd4j.linalg.dataset.api.MultiDataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.MultiDataSetIterator;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;

public class RecordReaderMultiDataSetIterator
implements MultiDataSetIterator {
    private int batchSize;
    private AlignmentMode alignmentMode;
    private Map<String, RecordReader> recordReaders = new HashMap<String, RecordReader>();
    private Map<String, SequenceRecordReader> sequenceRecordReaders = new HashMap<String, SequenceRecordReader>();
    private List<SubsetDetails> inputs = new ArrayList<SubsetDetails>();
    private List<SubsetDetails> outputs = new ArrayList<SubsetDetails>();
    private MultiDataSetPreProcessor preProcessor;

    private RecordReaderMultiDataSetIterator(Builder builder) {
        this.batchSize = builder.batchSize;
        this.alignmentMode = builder.alignmentMode;
        this.recordReaders = builder.recordReaders;
        this.sequenceRecordReaders = builder.sequenceRecordReaders;
        this.inputs.addAll(builder.inputs);
        this.outputs.addAll(builder.outputs);
    }

    public org.nd4j.linalg.dataset.api.MultiDataSet next() {
        return this.next(this.batchSize);
    }

    public void remove() {
        throw new UnsupportedOperationException("Remove not supported");
    }

    /*
     * WARNING - void declaration
     */
    public org.nd4j.linalg.dataset.api.MultiDataSet next(int num) {
        void var8_30;
        int n;
        int i;
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next elements");
        }
        HashMap nextRRVals = new HashMap();
        HashMap nextSeqRRVals = new HashMap();
        int minExamples = Integer.MAX_VALUE;
        for (Map.Entry<String, RecordReader> entry : this.recordReaders.entrySet()) {
            RecordReader recordReader = entry.getValue();
            ArrayList<List> arrayList = new ArrayList<List>(num);
            for (i = 0; i < num && recordReader.hasNext(); ++i) {
                arrayList.add(recordReader.next());
            }
            minExamples = Math.min(minExamples, arrayList.size());
            nextRRVals.put(entry.getKey(), arrayList);
        }
        for (Map.Entry<String, RecordReader> entry : this.sequenceRecordReaders.entrySet()) {
            SequenceRecordReader sequenceRecordReader = (SequenceRecordReader)entry.getValue();
            ArrayList<List> arrayList = new ArrayList<List>(num);
            for (i = 0; i < num && sequenceRecordReader.hasNext(); ++i) {
                List next = sequenceRecordReader.sequenceRecord();
                arrayList.add(next);
            }
            minExamples = Math.min(minExamples, arrayList.size());
            nextSeqRRVals.put(entry.getKey(), arrayList);
        }
        if (minExamples == Integer.MAX_VALUE) {
            throw new RuntimeException("Error occurred during data set generation: no readers?");
        }
        int[] longestSequence = null;
        if (this.alignmentMode == AlignmentMode.ALIGN_END) {
            longestSequence = new int[minExamples];
            for (Map.Entry entry : nextSeqRRVals.entrySet()) {
                List list = (List)entry.getValue();
                for (i = 0; i < list.size() && i < minExamples; ++i) {
                    longestSequence[i] = Math.max(longestSequence[i], ((List)list.get(i)).size());
                }
            }
        }
        int n2 = -1;
        if (this.alignmentMode != AlignmentMode.EQUAL_LENGTH) {
            for (Map.Entry entry : nextSeqRRVals.entrySet()) {
                List list = (List)entry.getValue();
                for (Object c : list) {
                    n = Math.max(n, c.size());
                }
            }
        }
        INDArray[] iNDArrayArray = new INDArray[this.inputs.size()];
        INDArray[] iNDArrayArray2 = new INDArray[this.inputs.size()];
        boolean inputMasks = false;
        int i2 = 0;
        for (SubsetDetails d : this.inputs) {
            List list;
            if (nextRRVals.containsKey(d.readerName)) {
                list = (List)nextRRVals.get(d.readerName);
                iNDArrayArray[i2] = this.convertWritables(list, minExamples, d);
            } else {
                list = (List)nextSeqRRVals.get(d.readerName);
                Pair<INDArray, INDArray> p = this.convertWritablesSequence(list, minExamples, n, d, longestSequence);
                iNDArrayArray[i2] = (INDArray)p.getFirst();
                iNDArrayArray2[i2] = (INDArray)p.getSecond();
                if (iNDArrayArray2[i2] != null) {
                    inputMasks = true;
                }
            }
            ++i2;
        }
        if (!inputMasks) {
            Object var8_29 = null;
        }
        INDArray[] outputArrs = new INDArray[this.outputs.size()];
        INDArray[] outputArrMasks = new INDArray[this.outputs.size()];
        boolean outputMasks = false;
        i2 = 0;
        for (SubsetDetails d : this.outputs) {
            List list;
            if (nextRRVals.containsKey(d.readerName)) {
                list = (List)nextRRVals.get(d.readerName);
                outputArrs[i2] = this.convertWritables(list, minExamples, d);
            } else {
                list = (List)nextSeqRRVals.get(d.readerName);
                Pair<INDArray, INDArray> p = this.convertWritablesSequence(list, minExamples, n, d, longestSequence);
                outputArrs[i2] = p.getFirst();
                outputArrMasks[i2] = p.getSecond();
                if (outputArrMasks[i2] != null) {
                    outputMasks = true;
                }
            }
            ++i2;
        }
        if (!outputMasks) {
            outputArrMasks = null;
        }
        MultiDataSet mds = new MultiDataSet(iNDArrayArray, outputArrs, (INDArray[])var8_30, outputArrMasks);
        if (this.preProcessor != null) {
            this.preProcessor.preProcess((org.nd4j.linalg.dataset.api.MultiDataSet)mds);
        }
        return mds;
    }

    private INDArray convertWritables(List<List<Writable>> list, int minValues, SubsetDetails details) {
        INDArray arr = details.entireReader ? Nd4j.create((int)minValues, (int)list.get(0).size()) : (details.oneHot ? Nd4j.zeros((int)minValues, (int)details.oneHotNumClasses) : Nd4j.create((int)minValues, (int)(details.subsetEndInclusive - details.subsetStart + 1)));
        for (int i = 0; i < minValues; ++i) {
            List<Writable> c = list.get(i);
            if (details.entireReader) {
                int j = 0;
                for (Writable w : c) {
                    try {
                        arr.putScalar(i, j, w.toDouble());
                    }
                    catch (UnsupportedOperationException e) {
                        if (w instanceof NDArrayWritable) {
                            arr.putRow(i, ((NDArrayWritable)w).get());
                        }
                        throw e;
                    }
                    ++j;
                }
                continue;
            }
            if (details.oneHot) {
                Writable w = null;
                if (c instanceof List) {
                    w = c.get(details.subsetStart);
                } else {
                    Iterator<Writable> iter = c.iterator();
                    for (int k = 0; k <= details.subsetStart; ++k) {
                        w = iter.next();
                    }
                }
                arr.putScalar(i, w.toInt(), 1.0);
                continue;
            }
            Iterator<Writable> iter = c.iterator();
            for (int j = 0; j < details.subsetStart; ++j) {
                iter.next();
            }
            int k = 0;
            for (int j = details.subsetStart; j <= details.subsetEndInclusive; ++j) {
                Writable w = iter.next();
                try {
                    arr.putScalar(i, k, w.toDouble());
                }
                catch (UnsupportedOperationException e) {
                    if (w instanceof NDArrayWritable) {
                        arr.putRow(i, ((NDArrayWritable)w).get().get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)details.subsetStart, (int)(details.subsetEndInclusive + 1))}));
                    }
                    throw e;
                }
                ++k;
            }
        }
        return arr;
    }

    private Pair<INDArray, INDArray> convertWritablesSequence(List<List<List<Writable>>> list, int minValues, int maxTSLength, SubsetDetails details, int[] longestSequence) {
        INDArray arr;
        if (maxTSLength == -1) {
            maxTSLength = list.get(0).size();
        }
        if (details.entireReader) {
            int size = list.get(0).iterator().next().size();
            arr = Nd4j.create((int[])new int[]{minValues, size, maxTSLength}, (char)'f');
        } else {
            arr = details.oneHot ? Nd4j.create((int[])new int[]{minValues, details.oneHotNumClasses, maxTSLength}, (char)'f') : Nd4j.create((int[])new int[]{minValues, details.subsetEndInclusive - details.subsetStart + 1, maxTSLength}, (char)'f');
        }
        boolean needMaskArray = false;
        for (List<List<Writable>> c : list) {
            if (c.size() >= maxTSLength) continue;
            needMaskArray = true;
        }
        INDArray maskArray = needMaskArray ? Nd4j.ones((int)minValues, (int)maxTSLength) : null;
        for (int i = 0; i < minValues; ++i) {
            List<List<Writable>> sequence = list.get(i);
            int startOffset = this.alignmentMode == AlignmentMode.ALIGN_START || this.alignmentMode == AlignmentMode.EQUAL_LENGTH ? 0 : longestSequence[i] - sequence.size();
            int t = 0;
            for (List<Writable> timeStep : sequence) {
                int j;
                Iterator<Writable> iter;
                int k = startOffset + t++;
                if (details.entireReader) {
                    iter = timeStep.iterator();
                    j = 0;
                    while (iter.hasNext()) {
                        Writable w = iter.next();
                        try {
                            arr.putScalar(i, j, k, w.toDouble());
                        }
                        catch (UnsupportedOperationException e) {
                            if (w instanceof NDArrayWritable) {
                                arr.get(new INDArrayIndex[]{NDArrayIndex.point((int)i), NDArrayIndex.all(), NDArrayIndex.point((int)k)}).putRow(0, ((NDArrayWritable)w).get());
                            }
                            throw e;
                        }
                        ++j;
                    }
                    continue;
                }
                if (details.oneHot) {
                    Writable w = null;
                    if (timeStep instanceof List) {
                        w = timeStep.get(details.subsetStart);
                    } else {
                        Iterator<Writable> iter2 = timeStep.iterator();
                        for (int x = 0; x <= details.subsetStart; ++x) {
                            w = iter2.next();
                        }
                    }
                    int classIdx = w.toInt();
                    arr.putScalar(i, classIdx, k, 1.0);
                    continue;
                }
                iter = timeStep.iterator();
                for (j = 0; j < details.subsetStart; ++j) {
                    iter.next();
                }
                int l = 0;
                for (int j2 = details.subsetStart; j2 <= details.subsetEndInclusive; ++j2) {
                    Writable w = iter.next();
                    try {
                        arr.putScalar(i, l++, k, w.toDouble());
                        continue;
                    }
                    catch (UnsupportedOperationException e) {
                        if (w instanceof NDArrayWritable) {
                            arr.get(new INDArrayIndex[]{NDArrayIndex.point((int)i), NDArrayIndex.all(), NDArrayIndex.point((int)k)}).putRow(0, ((NDArrayWritable)w).get().get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)details.subsetStart, (int)(details.subsetEndInclusive + 1))}));
                            continue;
                        }
                        throw e;
                    }
                }
            }
            if (!needMaskArray) continue;
            if (this.alignmentMode == AlignmentMode.ALIGN_END) {
                for (int t2 = 0; t2 < startOffset; ++t2) {
                    maskArray.putScalar(i, t2, 0.0);
                }
            }
            if (this.alignmentMode != AlignmentMode.ALIGN_START) continue;
            for (int t2 = t; t2 < maxTSLength; ++t2) {
                maskArray.putScalar(i, t2, 0.0);
            }
        }
        return new Pair<INDArray, INDArray>(arr, maskArray);
    }

    public void setPreProcessor(MultiDataSetPreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    public boolean resetSupported() {
        return true;
    }

    public void reset() {
        for (RecordReader recordReader : this.recordReaders.values()) {
            recordReader.reset();
        }
        for (SequenceRecordReader sequenceRecordReader : this.sequenceRecordReaders.values()) {
            sequenceRecordReader.reset();
        }
    }

    public boolean hasNext() {
        for (RecordReader recordReader : this.recordReaders.values()) {
            if (recordReader.hasNext()) continue;
            return false;
        }
        for (SequenceRecordReader sequenceRecordReader : this.sequenceRecordReaders.values()) {
            if (sequenceRecordReader.hasNext()) continue;
            return false;
        }
        return true;
    }

    private static class SubsetDetails {
        private final String readerName;
        private final boolean entireReader;
        private final boolean oneHot;
        private final int oneHotNumClasses;
        private final int subsetStart;
        private final int subsetEndInclusive;

        @ConstructorProperties(value={"readerName", "entireReader", "oneHot", "oneHotNumClasses", "subsetStart", "subsetEndInclusive"})
        public SubsetDetails(String readerName, boolean entireReader, boolean oneHot, int oneHotNumClasses, int subsetStart, int subsetEndInclusive) {
            this.readerName = readerName;
            this.entireReader = entireReader;
            this.oneHot = oneHot;
            this.oneHotNumClasses = oneHotNumClasses;
            this.subsetStart = subsetStart;
            this.subsetEndInclusive = subsetEndInclusive;
        }
    }

    public static class Builder {
        private int batchSize;
        private AlignmentMode alignmentMode = AlignmentMode.EQUAL_LENGTH;
        private Map<String, RecordReader> recordReaders = new HashMap<String, RecordReader>();
        private Map<String, SequenceRecordReader> sequenceRecordReaders = new HashMap<String, SequenceRecordReader>();
        private List<SubsetDetails> inputs = new ArrayList<SubsetDetails>();
        private List<SubsetDetails> outputs = new ArrayList<SubsetDetails>();

        public Builder(int batchSize) {
            this.batchSize = batchSize;
        }

        public Builder addReader(String readerName, RecordReader recordReader) {
            this.recordReaders.put(readerName, recordReader);
            return this;
        }

        public Builder addSequenceReader(String seqReaderName, SequenceRecordReader seqRecordReader) {
            this.sequenceRecordReaders.put(seqReaderName, seqRecordReader);
            return this;
        }

        public Builder sequenceAlignmentMode(AlignmentMode alignmentMode) {
            this.alignmentMode = alignmentMode;
            return this;
        }

        public Builder addInput(String readerName) {
            this.inputs.add(new SubsetDetails(readerName, true, false, -1, -1, -1));
            return this;
        }

        public Builder addInput(String readerName, int columnFirst, int columnLast) {
            this.inputs.add(new SubsetDetails(readerName, false, false, -1, columnFirst, columnLast));
            return this;
        }

        public Builder addInputOneHot(String readerName, int column, int numClasses) {
            this.inputs.add(new SubsetDetails(readerName, false, true, numClasses, column, -1));
            return this;
        }

        public Builder addOutput(String readerName) {
            this.outputs.add(new SubsetDetails(readerName, true, false, -1, -1, -1));
            return this;
        }

        public Builder addOutput(String readerName, int columnFirst, int columnLast) {
            this.outputs.add(new SubsetDetails(readerName, false, false, -1, columnFirst, columnLast));
            return this;
        }

        public Builder addOutputOneHot(String readerName, int column, int numClasses) {
            this.outputs.add(new SubsetDetails(readerName, false, true, numClasses, column, -1));
            return this;
        }

        public RecordReaderMultiDataSetIterator build() {
            if (this.recordReaders.isEmpty() && this.sequenceRecordReaders.isEmpty()) {
                throw new IllegalStateException("Cannot construct RecordReaderMultiDataSetIterator with no readers");
            }
            if (this.batchSize <= 0) {
                throw new IllegalStateException("Cannot construct RecordReaderMultiDataSetIterator with batch size <= 0");
            }
            if (this.inputs.isEmpty() && this.outputs.isEmpty()) {
                throw new IllegalStateException("Cannot construct RecordReaderMultiDataSetIterator with no inputs/outputs");
            }
            for (SubsetDetails ssd : this.inputs) {
                if (this.recordReaders.containsKey(ssd.readerName) || this.sequenceRecordReaders.containsKey(ssd.readerName)) continue;
                throw new IllegalStateException("Invalid input name: \"" + ssd.readerName + "\" - no reader found with this name");
            }
            for (SubsetDetails ssd : this.outputs) {
                if (this.recordReaders.containsKey(ssd.readerName) || this.sequenceRecordReaders.containsKey(ssd.readerName)) continue;
                throw new IllegalStateException("Invalid output name: \"" + ssd.readerName + "\" - no reader found with this name");
            }
            return new RecordReaderMultiDataSetIterator(this);
        }
    }

    public static enum AlignmentMode {
        EQUAL_LENGTH,
        ALIGN_START,
        ALIGN_END;

    }
}

