/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui;

import java.util.UUID;
import lombok.NonNull;

public class UiConnectionInfo {
    private String sessionId = UUID.randomUUID().toString();
    private String login;
    private String password;
    private String address = "localhost";
    private int port = 8080;
    private String path = "";
    private boolean useHttps;

    public void setSessionId(@NonNull String sessionId) {
        if (sessionId == null) {
            throw new NullPointerException("sessionId");
        }
        this.sessionId = sessionId;
    }

    public String getFirstPart() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.useHttps ? "https" : "http").append("://").append(this.address).append(":").append(this.port).append("");
        return builder.toString();
    }

    public String getSecondPart() {
        return this.getSecondPart("");
    }

    public String getSecondPart(String nPath) {
        StringBuilder builder = new StringBuilder();
        if (this.path != null && !this.path.isEmpty()) {
            builder.append(this.path.startsWith("/") ? this.path : "/" + this.path).append("/");
        }
        if (nPath != null) {
            builder.append((nPath = nPath.replaceFirst("^/", "")).startsWith("/") ? nPath : "/" + nPath).append("/");
        }
        return builder.toString().replaceAll("\\/{2,}", "/");
    }

    public String getFullAddress(String nPath) {
        if (nPath == null || nPath.isEmpty()) {
            return this.getFullAddress();
        }
        return this.getFirstPart() + this.getSecondPart(nPath) + "?sid=" + this.getSessionId();
    }

    public String getFullAddress() {
        return this.getFirstPart() + this.getSecondPart();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getLogin() {
        return this.login;
    }

    public String getPassword() {
        return this.password;
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isUseHttps() {
        return this.useHttps;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setUseHttps(boolean useHttps) {
        this.useHttps = useHttps;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UiConnectionInfo)) {
            return false;
        }
        UiConnectionInfo other = (UiConnectionInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sessionId = this.getSessionId();
        String other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !this$sessionId.equals(other$sessionId)) {
            return false;
        }
        String this$login = this.getLogin();
        String other$login = other.getLogin();
        if (this$login == null ? other$login != null : !this$login.equals(other$login)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        return this.isUseHttps() == other.isUseHttps();
    }

    protected boolean canEqual(Object other) {
        return other instanceof UiConnectionInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 0 : $sessionId.hashCode());
        String $login = this.getLogin();
        result = result * 59 + ($login == null ? 0 : $login.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 0 : $password.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 0 : $address.hashCode());
        result = result * 59 + this.getPort();
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 0 : $path.hashCode());
        result = result * 59 + (this.isUseHttps() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "UiConnectionInfo(sessionId=" + this.getSessionId() + ", login=" + this.getLogin() + ", password=" + this.getPassword() + ", address=" + this.getAddress() + ", port=" + this.getPort() + ", path=" + this.getPath() + ", useHttps=" + this.isUseHttps() + ")";
    }

    public static class Builder {
        private UiConnectionInfo info = new UiConnectionInfo();

        public Builder setSessionId(@NonNull String sessionId) {
            if (sessionId == null) {
                throw new NullPointerException("sessionId");
            }
            this.info.setSessionId(sessionId);
            return this;
        }

        public Builder setLogin(@NonNull String login) {
            if (login == null) {
                throw new NullPointerException("login");
            }
            this.info.setLogin(login);
            return this;
        }

        public Builder setPassword(String password) {
            this.info.setPassword(password);
            return this;
        }

        public Builder setAddress(@NonNull String address) {
            if (address == null) {
                throw new NullPointerException("address");
            }
            this.info.setAddress(address);
            return this;
        }

        public Builder setPort(int port) {
            if (port <= 0) {
                throw new IllegalStateException("UiServer port can't be <= 0");
            }
            this.info.setPort(port);
            return this;
        }

        public Builder enableHttps(boolean reallyEnable) {
            this.info.setUseHttps(reallyEnable);
            return this;
        }

        public Builder setPath(String path) {
            this.info.setPath(path);
            return this;
        }

        public UiConnectionInfo build() {
            return this.info;
        }
    }
}

