/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.params;

import java.util.Map;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.BasePretrainNetwork;
import org.deeplearning4j.nn.params.DefaultParamInitializer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class PretrainParamInitializer
extends DefaultParamInitializer {
    public static final String VISIBLE_BIAS_KEY = "bB";

    @Override
    public int numParams(NeuralNetConfiguration conf, boolean backprop) {
        if (backprop) {
            return super.numParams(conf, backprop);
        }
        BasePretrainNetwork layerConf = (BasePretrainNetwork)conf.getLayer();
        return super.numParams(conf, backprop) + layerConf.getNIn();
    }

    @Override
    public void init(Map<String, INDArray> params, NeuralNetConfiguration conf, INDArray paramsView, boolean initializeParams) {
        super.init(params, conf, paramsView, initializeParams);
        BasePretrainNetwork layerConf = (BasePretrainNetwork)conf.getLayer();
        params.put(VISIBLE_BIAS_KEY, Nd4j.valueArrayOf((int)layerConf.getNIn(), (double)0.0));
        conf.addVariable(VISIBLE_BIAS_KEY);
    }
}

